/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.comm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.ddf.IDdfFacetConst;

/**
 * This structure specifies an IP address and port.
 * 
 * @author lperkins
 */
public class BDdfIpAddressPort
  extends BStruct implements IDdfFacetConst
{
  /*-
  class BDdfIpAddressPort
  {
    properties
    {
      ipAddress : String
        default{["###.###.###.###"]}
        slotfacets{[MGR_INCLUDE]}
      ipPort : int
        default{[-1]}
        slotfacets{[MGR_INCLUDE]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.comm.BDdfIpAddressPort(4289322066)1.0$ @*/
/* Generated Tue Jan 06 08:21:39 EST 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "ipAddress"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ipAddress</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAddressPort#getIpAddress
   * @see com.tridium.ddfIp.comm.BDdfIpAddressPort#setIpAddress
   */
  public static final Property ipAddress = newProperty(0, "###.###.###.###",MGR_INCLUDE);
  
  /**
   * Get the <code>ipAddress</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAddressPort#ipAddress
   */
  public String getIpAddress() { return getString(ipAddress); }
  
  /**
   * Set the <code>ipAddress</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAddressPort#ipAddress
   */
  public void setIpAddress(String v) { setString(ipAddress,v,null); }

////////////////////////////////////////////////////////////////
// Property "ipPort"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ipPort</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAddressPort#getIpPort
   * @see com.tridium.ddfIp.comm.BDdfIpAddressPort#setIpPort
   */
  public static final Property ipPort = newProperty(0, -1,MGR_INCLUDE);
  
  /**
   * Get the <code>ipPort</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAddressPort#ipPort
   */
  public int getIpPort() { return getInt(ipPort); }
  
  /**
   * Set the <code>ipPort</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAddressPort#ipPort
   */
  public void setIpPort(int v) { setInt(ipPort,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfIpAddressPort.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  
  public BDdfIpAddressPort(String ip, int port)
  {
    setIpAddress(ip);
    setIpPort(port);
  }
  
  public BDdfIpAddressPort(int port, String ip)
  {
    this(ip,port);
  }
  
  public BDdfIpAddressPort()
  {
    
  }
  
  public BDdfIpAddressPort(int port)
  {
    setIpPort(port);
  }
  
  public BDdfIpAddressPort(String ip)
  {
    setIpAddress(ip);
  }
  
////////////////////////////////////////////////////////////////
// BDdfIpAddressPort API
////////////////////////////////////////////////////////////////

  /**
   * Optimizes the equivalent method.
   * 1.) Returns false if the given obj is null
   * 2.) Returns false if the class of the given obj is different from this
   * 3.) Returns true if the given obj's IpPort is the same as this obj's IpPort AND
   *     if the given obj's UpdIpAddress is the same as this obj's IpAddress 
   */
  public synchronized boolean equivalent(Object obj)
  {
    if (obj == null) return false;
    if (obj.getClass() != getClass()) return false;
    
    BDdfIpAddressPort otherAddr = (BDdfIpAddressPort)obj;
    
    return otherAddr.getIpPort() == this.getIpPort() &&
           otherAddr.getIpAddress().equals(this.getIpAddress());
  }
  
  /**
   * Gets the java.net.InetAddress representing this structure's "Ip Address"
   * 
   * @return the java.net.InetAddress object representing the IpAddress. If
   * the Ip address is the adapter's default then this returns Sys.getLocalHost()
   * @throws UnknownHostException
   */
  public InetAddress getInetAddress()
    throws UnknownHostException
  {
    if (getIpAddress().equals(BDdfIpAdapter.DEFAULT_IP_ADDR))
    {
      //NCCB-12273: Continue to use default definition of local host until
      //requirements of hint in this context can be defined
      return Sys.getLocalHost(null);
    }
    else
      return InetAddress.getByName(getIpAddress());
  }
  
  
}
