/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.point;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import com.tridium.ddfHttp.identify.BDdfHttpInspectPointId;
import com.tridium.ddfHttp.identify.BDdfHttpInspectReadParams;

/**
 * This is part of the devHttpDriver 'inspect' support whose purpose is
 * to allow drivers to inspect (comb) web pages for data and import the
 * data into a Niagara AX station as a standard Niagara AX driver control
 * point.
 * 
 * @author lperkins
 *
 */
public abstract class BDdfHttpInspectProxyExt
    extends BDdfProxyExt
{
  /*-
   class BDdfHttpInspectProxyExt
   {
     properties
     {
       readParameters : BDdfIdParams
         -- Defines a URL to retrieve HTTP data from.
         default{[new BDdfHttpInspectReadParams()]}
         slotfacets{[DdfFacets.MGR_INCLUDE]}
       pointId : BDdfIdParams
         -- Defines the regular expression that is used
         -- to extract a data value from the HTTP response. 
         default{[new BDdfHttpInspectPointId()]}
         slotfacets{[DdfFacets.MGR_INCLUDE]}
     }
   
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt(2080104985)1.0$ @*/
/* Generated Fri Feb 22 16:11:08 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "readParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>readParameters</code> property.
   * Defines a URL to retrieve HTTP data from.
   * @see com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt#getReadParameters
   * @see com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt#setReadParameters
   */
  public static final Property readParameters = newProperty(0, new BDdfHttpInspectReadParams(),DdfFacets.MGR_INCLUDE);
  
  /**
   * Get the <code>readParameters</code> property.
   * @see com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt#readParameters
   */
  public BDdfIdParams getReadParameters() { return (BDdfIdParams)get(readParameters); }
  
  /**
   * Set the <code>readParameters</code> property.
   * @see com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt#readParameters
   */
  public void setReadParameters(BDdfIdParams v) { set(readParameters,v,null); }

////////////////////////////////////////////////////////////////
// Property "pointId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pointId</code> property.
   * Defines the regular expression that is used to extract
   * a data value from the HTTP response.
   * @see com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt#getPointId
   * @see com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt#setPointId
   */
  public static final Property pointId = newProperty(0, new BDdfHttpInspectPointId(),DdfFacets.MGR_INCLUDE);
  
  /**
   * Get the <code>pointId</code> property.
   * @see com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt#pointId
   */
  public BDdfIdParams getPointId() { return (BDdfIdParams)get(pointId); }
  
  /**
   * Set the <code>pointId</code> property.
   * @see com.tridium.ddfHttp.point.BDdfHttpInspectProxyExt#pointId
   */
  public void setPointId(BDdfIdParams v) { set(pointId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpInspectProxyExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
