/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.comm.req;

import javax.baja.net.UrlConnection;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.req.BIDdfRequest;

/**
 * Requests implement this interface in order to gain direct access
 * to the Http data stream. For requests that implement this interface,
 * the 'processReceive' method will be bypassed.  Instead, the 
 * 'processHttpStream' method will be called and passed a direct reference
 * to the Http data stream.
 *   
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 */
public interface BIDdfHttpStreamRequest
  extends BIDdfRequest
{
  /**
   * The Ddf Http Transmitter calls this method after successfully establishing
   * an Http connection to the URL identified by the bytes that are returned by
   * the 'toByteArray' method for this request.
   * 
   * NOTE: This method is called on the driver's communicator thread, the same
   * thread that arranges for transmission of all requests. Please use discretion
   * when performing any operations that might take an extended amount of time.
   *
   * @param UrlConnection the javax.baja.net.UrlConnection, already connected and
   * ready for the defining class to read from its input stream.
   * 
   * @param return true if the driver is finished with the UrlConnection. In which
   * case, the Dev Http Driver framework will automatically call '.close()' on the
   * UrlConnection. If false is returned then it is the responsibility of the 
   * implementor to call '.close()' on the given UrlConnection. If the implementor
   * wishes to process the UrlConnection on another thread then the implementor
   * should return false and call 'close' when the implementor is finished with
   * the UrlConnection.
   */
  public boolean processHttpStream( UrlConnection mostRecentBajaUrlConnection );

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
 
  public static final Type TYPE = Sys.loadType(BIDdfHttpStreamRequest.class);
}