/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.comm;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;

/**
 * This is the standard transmitter property that serves as the 'transmitter'
 * for the BDdfHttpCommunicator.
 * 
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 */
public class BDdfHttpTransmitter
    extends BDdfTransmitter
{
  /*-
   class BDdfHttpTransmitter
   {
     properties
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.comm.BDdfHttpTransmitter(2963168211)1.0$ @*/
/* Generated Fri Feb 22 14:52:47 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpTransmitter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// API
////////////////////////////////////////////////////////////////
  
  public BDdfHttpCommunicator getHttpCommunicator()
  {
    return (BDdfHttpCommunicator)getDdfCommunicator();
  }
  
  /**
   * This creates the DdfHttpHelper object that performs
   * the HTTP transmit on behalf of this object. The default
   * implementation should suffice. However, if a developer
   * ever encounters a scenario where he or she feels that
   * he or she needs to customize the HTTP details then he
   * or she may extend this and return an instance of his
   * or her own customized class that extends DdfHttpHelper.
   */
  protected DdfHttpHelper makeHttpHelper()
  {
    return new DdfHttpHelper(this);
  }
  
  protected DdfHttpHelper getHttpHelper()
  {
    if (ddfHttpHelper == null)
    {
      ddfHttpHelper = makeHttpHelper();
    }
    return ddfHttpHelper;
  }  
  
////////////////////////////////////////////////////////////////
// BDdfCommunicator
////////////////////////////////////////////////////////////////

  /**
   * Implements the 'forceTransmit' method from BDdfCommunicator by
   * connecting to the URL whose ascii bytes are returned by the
   * 'toByteArray' method of the given ddfRequest. The 'toByteArray'
   * method may optionally add the text 'POST ' (that is, post
   * followed by a space) to the front of the ascii bytes that it
   * returns. If so, then any data after the optional '?' (question-
   * mark character) will be sent in the data portion as an HTTP
   * POST. Otherwise, any optional data after the optional '?' 
   * (question-mark character) will be sent as part of the URI as
   * an HTTP GET. 
   */
  public void forceTransmit(BIDdfRequest ddfRequest) throws Exception
  {
    // The following call is synchronized on ddfHttpHelper. It waits for the
    // receive thread to set 'receiverReadyToReceive' to true (if it is
    // false), then opens the Http connection, and posts any form data
    getHttpHelper().transmitWhenReadyToReceive(ddfRequest);
  }
  
  public void stopTransmitter()
  {
    getHttpHelper().stopHelping();
    ddfHttpHelper = null; // Forces the next call to getHttpHelper to re-allocate
  }
  

  
////////////////////////////////////////////////////////////////
// DdfHttpHelper - 
////////////////////////////////////////////////////////////////
  
  /**
   * This is used for Java multi-thread synchronization between the Http transmitter
   * and the Http receiver. It also encapsulates that low-level details of Http
   * transmitting and receiving.
   */
  protected DdfHttpHelper ddfHttpHelper;
  
  /**
   * This is placed in the Http Request Header as part of the authentication
   * process.
   */
  public static final String AUTHORIZATION = "Authorization";
  
  /**
   * This is placed in the Http Request Header as part of the authentication
   * process.
   */
  public static final String BASIC = "Basic ";
  
}
