/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.comm;

import javax.baja.nre.util.ByteBuffer;
import javax.baja.net.HttpException;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfNullReceiver;

/**
 * This is the standard receiver property that serves as the 'receiver'
 * for the BDdfHttpCommunicator.
 * 
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 */
public class BDdfHttpReceiver
    extends BDdfNullReceiver
{
  /*-
  class BDdfHttpReceiver
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.comm.BDdfHttpReceiver(63629220)1.0$ @*/
/* Generated Fri Feb 22 14:52:47 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpReceiver.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  /**
   * Sets the default response timeout to 30 seconds.
   */
  public BDdfHttpReceiver()
  {
    setResponseTimeout(BRelTime.makeSeconds(10));
  }
  
  public BDdfHttpCommunicator getHttpCommunicator()
  {
    return (BDdfHttpCommunicator)getDdfCommunicator();
  }
  
  /**
   * This method must be implemented to recognize and receive a frame of data from the field-bus.
   * 
   * If overridden then this method must block and only return once a frame of data is received.
   *
   * Hopefully, the default implementation of this method will suffice. It would allow the descendant
   * to simply implement the abstract isCompleteFrame and isStartOfFrame methods.
   * 
   * @return An object that implements the IDdfDataFrame interface that represents some data that was
   * just received from the field-bus.
   */
  protected IDdfDataFrame doReceiveFrame()
    throws Exception
  {
    // Resets the internal IDdfDataFrame that this object customizes from its
    // parent class
    resetReceiveBuffer();
    
    // Gets the http transmitter from the http communicator 
    BDdfHttpTransmitter httpTransmitter = getHttpCommunicator().getHttpTransmitter();
    
    try
    {
      // Reads the data that the Http connection returns. Reads the data into the internal buffer.
      getInternalHttpBuffer().write( httpTransmitter.getHttpHelper().waitReceiveNextAndClose() );
    }
    catch (HttpException he)
    {
      receiveFrame.httpException = he;
    }
    
    // Returns the internal buffer, which was just filled with the Http content
    return receiveFrame;
  }
  
  /**
   * The descendants may customize if they wish. Hopefully the default implementation will
   * suffice though.
   */
  protected void resetReceiveBuffer()
  {
    receiveFrame.reset();
    receiveFrame.httpException=null;
  }
  
  /**
   * Returns the internal buffer for this object. Hopefully the default implementation will
   * suffice. That would make it easier for descendants. However, descendants may customize
   * this if they wish.
   * @return
   */
  protected DdfHttpReceiveFrame getInternalHttpBuffer()
  {
    return receiveFrame;
  }  
  
////////////////////////////////////////////////////////////////
//DdfReceiveFrame
////////////////////////////////////////////////////////////////
 
 /**
  * 
  * If descendants wish to perform advanced customization, they can gain
  * access to this class by calling the getInternalBuffer method on the
  * outer class. That will give them a direct reference to the internal
  * instance of this buffer that is maintained on the outer instance. By
  * gaining a direct reference in this fashion, the descendant can directly
  * add, remove, delete, etc. bytes directly from the internal buffer.
  * 
  * @author    lperkins
  * @creation  Mar 25, 2008
  * @version   $Revision$ $Date$
  * @since     Niagara 3.0
  */
  public static class DdfHttpReceiveFrame
      extends ByteBuffer
      implements IDdfDataFrame
  {
    /**
     * Creates a DdfHttpReceiveFrame with an initial capacity of 1/2 K, which should be good enough
     * for most cases. Since this extends ByteBuffer, the internal byte array will automatically be
     * increased, however, if 1/2 K is not enough.
     */
    protected DdfHttpReceiveFrame(BDdfHttpReceiver httpReceiver)
    {
      super(512); // Initial capacity of 1/2 K should be good enough for most cases
    }

    /**
     * Returns a direct reference to the byte array buffer for this data frame.
     * 
     * Note that not all bytes are necessarily valid. Please only access bytes from index zero
     * through the index that is returned by calling the 'getFrameSize' method.
     */
    public byte[] getFrameBytes()
    {
      return getBytes();
    }

    public HttpException getHttpException()
    {
      return httpException;
    }

    /**
     * Returns the number of valid bytes in this data frame.
     * 
     * @return the number of valid bytes in this data frame.
     */
    public int getFrameSize()
    {
      return getLength();
    }

    /**
     * Delegates to the 'computeTag' method on the BDdfReceiver.
     */
    public BSimple getFrameTag()
    {
      return httpReceiver.computeTag(this);
    }

    /**
     * Creates a byte-per-byte copy of this data frame.
     */
    public IDdfDataFrame getFrameCopy()
    {
      DdfHttpReceiveFrame retVal = new DdfHttpReceiveFrame(httpReceiver);
      retVal.write(toByteArray());
      retVal.httpException = httpException;
      return retVal;
    }

    public HttpException httpException = null;

    protected final BDdfHttpReceiver httpReceiver = null;
  }
  
  /**
   * This is a reference to the internal receiveFrame for the BDdfHttpReceiver.
   */
  DdfHttpReceiveFrame receiveFrame = new DdfHttpReceiveFrame(this);  
  
}
