/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.comm;

import java.net.MalformedURLException;

import javax.baja.security.BICredentials;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionCommunicator;
import com.tridium.ddfHttp.comm.req.BIDdfHttpCredentialsReq;
import com.tridium.ddfHttp.comm.req.BIDdfHttpStreamRequest;

/**
 * This is an HTTP communicator for use on driver networks or driver
 * devices that communicate to field equipment over HTTP.
 * 
 * For standard HTTP communications, driver devices should extend
 * BDdfHttpDevice, which includes a standard BDdfHttpCommunicator
 * as Niagara AX child property.
 * 
 * @author    Lenard Perkins
 * @creation  01 Jan 08
 * @version   $Revision$ $Date: 02/19/2009 3:42:00 PM$
 * @since     Baja 1.0
 */
public class BDdfHttpCommunicator
  extends BDdfSingleTransactionCommunicator
{
  /*-
   class BDdfHttpCommunicator
   {
     properties
     {
       transmitter : BDdfTransmitter
         -- This item transmits messages for the communicator.
         default{[ new BDdfHttpTransmitter() ]}
       receiver : BDdfReceiver
         -- This is a place-holder for the receiver.
         default{[ new BDdfHttpReceiver() ]}
       credentials : BDdfHttpUserNameAndPassword
         -- The user name and password to use if the Http server requires a user
         -- name and password.
         default{[new BDdfHttpUserNameAndPassword()]}
         slotfacets{[DdfFacets.combine(MGR_INCLUDE, MGR_OPTIONAL_IN_TABLE)]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.comm.BDdfHttpCommunicator(579969109)1.0$ @*/
/* Generated Fri Feb 06 16:44:14 EST 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transmitter"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transmitter</code> property.
   * This item transmits messages for the communicator.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#getTransmitter
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#setTransmitter
   */
  public static final Property transmitter = newProperty(0, new BDdfHttpTransmitter(),null);
  
  /**
   * Get the <code>transmitter</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#transmitter
   */
  public BDdfTransmitter getTransmitter() { return (BDdfTransmitter)get(transmitter); }
  
  /**
   * Set the <code>transmitter</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#transmitter
   */
  public void setTransmitter(BDdfTransmitter v) { set(transmitter,v,null); }

////////////////////////////////////////////////////////////////
// Property "receiver"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>receiver</code> property.
   * This is a place-holder for the receiver.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#getReceiver
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#setReceiver
   */
  public static final Property receiver = newProperty(0, new BDdfHttpReceiver(),null);
  
  /**
   * Get the <code>receiver</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#receiver
   */
  public BDdfReceiver getReceiver() { return (BDdfReceiver)get(receiver); }
  
  /**
   * Set the <code>receiver</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#receiver
   */
  public void setReceiver(BDdfReceiver v) { set(receiver,v,null); }

////////////////////////////////////////////////////////////////
// Property "credentials"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>credentials</code> property.
   * The user name and password to use if the Http server
   * requires a user name and password.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#getCredentials
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#setCredentials
   */
  public static final Property credentials = newProperty(0, new BDdfHttpUserNameAndPassword(),DdfFacets.combine(MGR_INCLUDE, MGR_OPTIONAL_IN_TABLE));
  
  /**
   * Get the <code>credentials</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#credentials
   */
  public BDdfHttpUserNameAndPassword getCredentials() { return (BDdfHttpUserNameAndPassword)get(credentials); }
  
  /**
   * Set the <code>credentials</code> property.
   * @see com.tridium.ddfHttp.comm.BDdfHttpCommunicator#credentials
   */
  public void setCredentials(BDdfHttpUserNameAndPassword v) { set(credentials,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// API
////////////////////////////////////////////////////////////////
 
 /**
  * Returns the value of the 'transmitter' slot cast to BDdfHttpTransmitter.
  */
 public BDdfHttpTransmitter getHttpTransmitter()
 {
   return (BDdfHttpTransmitter)getDdfTransmitter();
 }
 
 /**
  * Returns the value of the 'receiver' slot cast to BDdfHttpTransmitter.
  */
 public BDdfHttpReceiver getHttpReceiver()
 {
   return (BDdfHttpReceiver)getDdfReceiver();
 }
  
////////////////////////////////////////////////////////////////
// Descendant Overrides
////////////////////////////////////////////////////////////////

  /**
   * Gets the user name and password for the given BIDdfRequest. By default, this returns the value of the
   * username property. Drivers may override if they need to define a different username per
   * request.
   */
  public BICredentials getHttpCredentials(BIDdfRequest ddfHttpRequest)
  {
    if (ddfHttpRequest instanceof BIDdfHttpCredentialsReq)
    {
      BICredentials reqCredentials = ((BIDdfHttpCredentialsReq)ddfHttpRequest).getCredentials();
      
      if (reqCredentials == null)
        return getCredentials();
      else
        return reqCredentials; 
    }
    else
    {
      return getCredentials();
    }
  }

  
  /**
   * Gets the HTTP-CONTENT-TYPE for the given BIDdfRequest.
   *  
   * @param ddfHttpRequest
   * 
   * @return "application/x-www-form-urlencoded" by default. This
   * method may be overridden if a different HTTP-CONTENT-TYPE
   * is required.
   */
  public String getHttpContentType(BIDdfRequest ddfHttpRequest)
  {
    return "application/x-www-form-urlencoded";
  }
  
  /**
   * Gets the timeout for the HTTP socket connection. 
   * 
   * @return by default this returns 0 which effectively disables the
   * socket timeout. This method may be overriden if a different
   * HTTP-CONTENT-TYPE is required
   */
  public int getSoTimeout(BIDdfRequest ddfHttpRequest)
  {
    return (int)ddfHttpRequest.getResponseTimeout().getMillis();
  }

  /**
   * The doCommunicate method calls this method for any ddf request that
   * implements BIDdfHttpStreamRequest. It calls this method before calling
   * super.doCommunicate(ddfRequest).
   * 
   * By default, this causes the standard BDdfCommunicator and BDdfTransactionMgr
   * logic to treat this request like a raw-transmit request and not process it
   * in a request-response transaction. This is necessary because the request
   * itself will be consuming the response bytes and leaving nothing to remain
   * for dev driver to process a response for. This is accomplished by changing
   * the respone time on the request to BRelTime.DEFAULT.
   * 
   * If driver developers do not desire this functionality then they may
   * override this method and either do nothing or do anything that they
   * might prefer to do differently.
   */
  protected void preProcessStreamRequest(BIDdfHttpStreamRequest ddfRequest)
  {
    // This causes the standard BDdfCommunicator and BDdfTransactionMgr logic to
    // treaT this request like a raw-transmit request and not process it in a
    // request-response transaction. This is necessary because the request itself
    // will be consuming the response bytes and leaving nothing to remain for
    // dev driver to process a response for.
    ddfRequest.setResponseTimeout( BRelTime.DEFAULT );
  }
  
  protected void preValidateUrl(BIDdfRequest ddfRequest)
    throws Exception
  {
    if (httpUrlChecker == null)
      httpUrlChecker = new HttpUrlChecker();
    httpUrlChecker.checkUrl(ddfRequest);
  }

  public void doCommunicate(BIDdfRequest ddfRequest)
  {
    if (ddfRequest instanceof BIDdfHttpStreamRequest)
    {
      preProcessStreamRequest( (BIDdfHttpStreamRequest)ddfRequest );
    }
    
    try
    {
      preValidateUrl(ddfRequest);
      
      // TODO Auto-generated method stub
      super.doCommunicate(ddfRequest);
    }
    catch (Exception e)
    {
      // Treats this scenario as a timeout. Think of it this way:
      //   An invalid URL times-out very quickly! We know that
      //   the request would time out if we were to attempt to
      //   transmit it. So we are just making it timeout faster.
      DdfRequestUtil.processTimeout(ddfRequest);
    }
  }
  
  /**
   * Descendants may override if they wish for the receive frames
   * to be printed as pure text during station debug trace.
   * 
   * @return false
   */
  public boolean traceText()
  {
    return false;
  }
  
  class HttpUrlChecker extends DdfHttpHelper
  {
    HttpUrlChecker()
    {
      super(getHttpTransmitter());
    }
    
    void checkUrl(BIDdfRequest ddfRequest)
      throws MalformedURLException
    {
      // Assigns the mostRecentDdfRequest and the httpCommunicator,
      // which is a necessary precondition of the ancestor of this
      // inner class in order to call the 'parseJavaUrl method.
      mostRecentDdfRequest = ddfRequest;
      httpCommunicator = BDdfHttpCommunicator.this;
      parseJavaUrl();
      String host = mostRecentJavaUrl.getHost();
      if (host.length() == 0 ||
          host.equals("###.###.###.###") || // NOTE: devHttpDriver.jar does not have dependency on devIpDriver.jar so hard-code these strings
          host.equals("[***DEFAULT***]"))
      {
        throw new MalformedURLException("Invalid host: "+host);
      }
    }
    
  }
  
  HttpUrlChecker httpUrlChecker;
}
