/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui.device;

import javax.baja.driver.ui.device.DeviceState;
import javax.baja.workbench.mgr.BAbstractManager;

import com.tridium.ddf.ui.DdfMgrStateUtil;

/**
 * Preserves the Ddf Device Manager's state if the user temporarily
 * navigates away.
 * 
 * @author lperkins
 *
 */
public class DdfDeviceState
  extends DeviceState
{
  
////////////////////////////////////////////////////////////////
// FolderState
////////////////////////////////////////////////////////////////
  
  protected void restoreForType(BAbstractManager manager)
  {
    super.restoreForType(manager);
    
    if (manager instanceof BDdfDeviceManager)
      DdfMgrStateUtil.restoreState((BDdfDeviceManager)manager);
  }

  protected void saveForType(BAbstractManager manager)
  {
    super.saveForType(manager);
    
    if (manager instanceof BDdfDeviceManager)
      DdfMgrStateUtil.saveState((BDdfDeviceManager)manager);
  }
}
