/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui.device;

import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences;
import com.tridium.ddf.ui.DdfMgrLearn;
import com.tridium.ddf.ui.DdfMgrUtil;

/**
 * The DdfDeviceManager is a registered Niagara AX agent on
 * BDdfCommNetwork and BDdfDeviceFolder. It automatically
 * appears on them as one of their  Niagara AX 'Views'.
 *
 * This provides a fully-functional device manager for drivers
 * that are built on the devDriver framework. This uses introspection
 * plus the rest of the ddf to make this happen.
 *
 * @author lperkins
 */
public class BDdfDeviceManager
  extends BDeviceManager
  implements IDdfFacetConst
{
  /*-
   class BDdfDeviceManager
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.ui.device.BDdfDeviceManager(2760090023)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDeviceManager.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Plugs an DdfDeviceModel into the standard Niagara AX mgr framework.
   */
  protected MgrModel makeModel(){return new DdfDeviceModel(this);}
  
/////////////////////////////////////////////////////////////////////////
// BAbstractManager
/////////////////////////////////////////////////////////////////////////
  
  /**
   * Plugs an DdfMgrLearn into the standard Niagara AX mgr framework, if the
   * manager's discovery host specifies a discovery leaf type and it is customized
   * in the end-driver (otherwise, this plugs in no MgrLearn).
   */
	protected MgrLearn makeLearn()
  {
    Type discoveryLeafType = DdfMgrUtil.getDiscoveryLeafType(this);
    
    if (discoveryLeafType==null || // If the discovery host does not define a discovery leaf type
        discoveryLeafType == BDdfAutoDiscoveryPreferences.TYPE || // Or the driver developer has not customized it at all
        discoveryLeafType == BDdfDiscoveryPreferences.TYPE) // Or the driver developer has not customized it from the 'auto' discovery
      return null;
    else
      return new DdfMgrLearn(this);

  }
	 
  /**
   * Plugs an DdfDeviceController into the standard Niagara AX mgr framework.
   */
  protected MgrController makeController()
  {
    return new DdfDeviceController(this);
  }
  
  /**
   * Plugs an DdfDeviceState into the standard Niagara mgr framework.
   */
  protected MgrState makeState()
  {
    return new DdfDeviceState();
  }

/////////////////////////////////////////////////////////////////////////
// BAbstractManager
/////////////////////////////////////////////////////////////////////////
  
  /**
   * Customizes the doLoadValue method.
   *
   * Possibly updates the DdfMgrLearn with a set of cached discovery object
   * from the manager's ddf discovery host's discovery folder.
   *
   * Calls DdfMgrUtil.doLoadManager
   *
   * @see DdfMgrUtil.doLoadManager
   */
  public void doLoadValue(BObject obj, Context cx)
  {
    super.doLoadValue(obj,cx);
    DdfMgrUtil.doLoadManager(this);
  }

/////////////////////////////////////////////////////////////////////////
// Event Handling
/////////////////////////////////////////////////////////////////////////
  
  public void handleComponentEvent(BComponentEvent event)
  {
    super.handleComponentEvent(event);

    // If a BDdfDevice is added, then we need to subscribe
    // To its communicator component. The core classes from
    // Which we extend do not dive deep enough, nor would
    // We want them to arbitrarily dive that deep. We know
    // That we need to subscribe to the communicator component
    // So that any MgrColumns that are tied to properties on
    // The device's communicator will be refreshed automatically
    // On the screen.
    if (event.getId()==BComponentEvent.PROPERTY_ADDED &&
        event.getValue() instanceof BDdfDevice )
    {
      registerDeviceCommunicator((BDdfDevice)event.getValue());
    }
  }
  
/////////////////////////////////////////////////////////////////////////
// Subscription
/////////////////////////////////////////////////////////////////////////
  
  /**
   * Subscribes deeply for component events upon the given ddfDevice's
   * communicator (if the communicator is a component).
   *
   * We do this so that any MgrColumns that are tied to properties on
   * The device's communicator will be refreshed automatically
   * On the screen.
   *
   * This method is called by  DdfDeviceModel.load and from
   * BDdfDeviceManager.handleComponentEvent
   *
   * @param ddfDeviceRow a ddf device that is a row in the database table.
   */
  void registerDeviceCommunicator(BDdfDevice ddfDeviceRow)
  {
    // If the ddf device's communicator is a BComponent then we
    // Need to subscribe deeply to it, in order to fetch any MGR_INCLUDE
    // Properties and put them onto the manager. This is important for
    // Devices that have their own communications port, such as Tcp/Ip
    // Devices.
    if (ddfDeviceRow.getDdfCommunicator() instanceof BComponent)
    { 
      // Subscribes reasonably deep enough to get everything reasonably underneath the developer's
      // communicator
      registerForComponentEvents((BComponent)ddfDeviceRow.getDdfCommunicator(),3);
    }
  }

/////////////////////////////////////////////////////////////////////////
// BDdfDeviceManager
/////////////////////////////////////////////////////////////////////////
  
  /**
   * Gets the corresponding BDDfNetwork for this device manager.
   */
  public BDdfNetwork getDdfNetwork()
  {
    return DdfMgrUtil.findDdfNetwork(this);
  }

}
