/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.ui;

import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

import com.tridium.ddf.discover.BIDdfDiscoveryObject;

/**
 * This class contains methods and attributes that help clean up other areas
 * of the source code that are used to display localized text.
 * 
 * @author lperkins
 */
public class DdfUiLexicon
{
  public static final Lexicon LEX = Lexicon.make(DdfUiLexicon.class);

  // This error is placed in the Workbench standard-out console and possibly displayed to the driver developer in
  // A pop-up error-box if they mix their own user interface manager with the standard developer driver auto-learn feature.
  // The value in parameter {0} is the unsupported manager's type name.
  // UnsupportedManagerTypeForAutoDiscovery = Unsupported manager type for auto-discovery: {0}
  public static final String UNSUPPORTED_MANAGER_TYPE_FOR_AUTO_DISCOVERY = "UnsupportedManagerTypeForAutoDiscovery";
  
  public static String unsupportedManagerTypeForAutoDiscovery(Type badType)
  {
    return LEX.getText(UNSUPPORTED_MANAGER_TYPE_FOR_AUTO_DISCOVERY, new Object[]{badType});
  }
  
  public static final String DISCOVERY_LEAF_NEEDS_MGR_INCLUDE_FACETS="DiscoveryLeafNeedsMgrIncludeFacets";
  
  public static final String discoveryLeafNeedsMgrIncludeFacets(BIDdfDiscoveryObject discoveryLeaf)
  {
    return LEX.getText(DISCOVERY_LEAF_NEEDS_MGR_INCLUDE_FACETS, new Object[]{discoveryLeaf.getType().getTypeSpec()});
  }
}
