/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.poll;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.IDdfReadable;

/**
 * If you are designing a driver that extends the ddf and you would like
 * to introduce some data to the Niagara AX framework, then you should define some classes
 * that implement the BIDdfPollable interface.
 *
 * HINT: The most typical usage is where proxy extensions are placed on proxy points under a ddf
 * device. We encourage you to adopt this model and extend the ddf proxy ext.
 *
 * Even though this interface does not extend javax.baja.driver.sys.BIPollable, implementing classes
 * are encouraged to implement BIPollable if it could make sense for them to have a poll frequency.
 *
 * @author    lperkins
 * @creation  Oct 10, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface BIDdfPollable
    extends BInterface, IDdfReadable, IDdfFacetConst
{
  public Type getReadRequestType();

  /**
   * HINT: Making this method return something other than null is optional.
   *
   * Allows a group of BIDdfPollables to be polled using a single message on the field-bus.
   *
   * All BIDdfPollables that can be polled in a single message on the field-bus should return
   * the same reference from this method. The easiest example would be where a group of ddf
   * proxies returns the instance of their ddf device. That would cause all ddf proxies under
   * the ddf device to be polled in a single field-bus message.
   */
  public Object getPollGroupCode();

  /**
   * Indicates the BDdfCommunicator that will send and/or receive field-bus messages for this object. This
   * could vary widely based on the communication medium. For serial drivers, the ddf communicator object is
   * usually placed on the ddf network. For tcp driver, the ddf communicator object is typically placed on
   * the ddf network if the network acts as a gateway, or on the ddf device if the field device has its own
   * i.p. address.
   */
  public BIDdfCommunicator getDdfCommunicator();
  
  /**
   * Instances need to construct an instance of BIDdfReadRequest to be placed on the ddf
   * communicator. The ddf communicator will make 'transmit' the serialized data from this
   * BIDdfReadRequest onto the field-bus and make call-backs to this BIDdfReadRequest object
   * when the response is receive or timed out.
   */
  public BIDdfReadRequest makePollRequest();

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfPollable.class);
}
