/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.poll;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * The BDdfPollScheduler implements this interface.
 *
 * Any driver that is built on the ddf that needs to create a
 * custom poll scheduler (that task is highly atypical and discouraged) should
 * implement this interface as well. This is possible because the BIDdfPollable
 * itself returns a BIDdfPollScheduler from its getDdfPollScheduler method. If
 * the driver customized the ddf poll scheduler then its BIDdfPollable's will
 * need to return an instance of the driver's custom BIDdfPollScheduler too.
 *
 * @author    lperkins
 * @creation  Oct 10, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface BIDdfPollScheduler
    extends BInterface, IDdfFacetConst
{
  /**
   * Called to subscribe a BIDdfPollable for updates. DdfPollUtil.readSubscribed
   * calls this method.
   * @param ddfPollableValue the ddf pollable value to subscribe
   */
  public void subscribe(BIDdfPollable ddfPollableValue);
  
  /**
   * Called to unsubscribe a BIDdfPollable for updates. DdfPollUtil.readUnsubscribed
   * calls this method.
   * @param ddfPollableValue the ddf pollable value to unsubscribe
   */
  public void unsubscribe(BIDdfPollable ddfPollableValue);
  
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfPollScheduler.class);

}
