/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.point;

import javax.baja.util.Lexicon;

/**
 * This class contains methods and attributes that help clean up other areas
 * of the source code that are used to display localized text.
 * 
 * @author lperkins
 */
public class DdfPointLexicon
{
  private DdfPointLexicon(){} // Not instantiable! Access provided through static methods.
  
  public static final Lexicon LEX = Lexicon.make(DdfPointLexicon.class);

  // The following is placed in the station's standard output when scheduling a data point to be written,
  // If trace is enabled for a point's ddf Communicator.
  // write = Write
  public static final String WRITE_KEY = "write";
  
  public static final String write = LEX.getText(WRITE_KEY);
  
  
  // The following is placed in the station's standard output when scheduling a data point to be auto'ed,
  // If trace is enabled for a point's ddf Communicator.
  // auto = Auto
  public static final String AUTO_KEY = "auto";
  
  public static final String auto = LEX.getText(AUTO_KEY);

  // The following is placed in the station's standard output
  // If there is any error scheduling a data point to be written in
  // A driver. This error is very atypical and will probably
  // Never be displayed.
  // postWriteFail = Unable to Schedule Point to be Written
  public static final String POST_WRITE_FAIL = "postWriteFail";
  
  public static final String postWriteFail = LEX.getText(POST_WRITE_FAIL);


  // The following is placed in the station's standard output
  // If there is any error scheduling a data point to be auto'ed in
  // A driver. This error is very atypical and will probably
  // Never be displayed.
  // postAutoFail = Unable to Schedule Point to be "auto'ed"
  public static final String POST_AUTO_FAIL = "postAutoFail";
  
  public static final String postAutoFail = LEX.getText(POST_AUTO_FAIL);


  // This following is placed in the station's standard output as well
  // As an error log in the station if the user changes the readParameters
  // On a proxy point and the driver experiences an unexpected error while
  // Performing the necessary maintenance as a result of changing the readParameters.
  // Parameter {0} will be the slot path of the proxy on which the error occurred
  // errorChangingReadRequestId = An error occurred while processing the change to the readParameters of proxy {0}
  public static final String ERROR_CHANGING_READ_REQUEST_ID = "errorChangingReadRequestId";
  
  public static final String errorChangingReadRequestId(BDdfProxyExt ezProxy)
  {
    return LEX.getText(ERROR_CHANGING_READ_REQUEST_ID, new Object[]{ezProxy.getSlotPath()});
  }

  // The following text is a simple trace message indicating that a point was auto'ed in Niagara
  // But the driver will take no special action as a result. This is not necessarily
  // A bad thing, in fact it could be by design, unless the particular driver's equipment requires
  // That a special message be sent to relinquish control of the point. If that were to be the case then the
  // Driver developer will need to define the auto request within the ddf.
  // Parameter {0} is the result of calling the point's toString method
  // NoAutoRequestDefined = Point Auto - No special driver communication necessary - Point = {0}
  public static final String NO_AUTO_REQUEST_DEFINED = "NoAutoRequestDefined";
  
  public static String noAutoRequestDefined(String slotPath)
  {
    return LEX.getText(NO_AUTO_REQUEST_DEFINED, new Object[]{slotPath});
  }

  // The following error will occur if a driver point is written from Niagara but the driver does
  // Not define the write request to apply to change to the driver's equipment.
  // Parameter {0} is the result of calling the point's toString method
  // WriteNotImplemented = Writing Not Implemented For Point: {0}
  public static final String WRITE_NOT_IMPLEMENTED = "WriteNotImplemented";
  
  public static String writeNotImplemented(String slotPath)
  {
    return LEX.getText(WRITE_NOT_IMPLEMENTED, new Object[]{slotPath});
  }

}
