/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.point;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.req.util.DdfWriteRequestUtil;
import com.tridium.ddf.discover.BDdfDiscoveryGroup;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfAutoParams;
import com.tridium.ddf.identify.BIDdfReadParams;
import com.tridium.ddf.identify.BIDdfWriteParams;
import com.tridium.ddf.poll.BDdfPollGroup;
import com.tridium.ddf.poll.BIDdfPollable;

/**
 * Drivers that build off of the ddf should
 * provide at least one proxy extension class that extends this
 * class.
 *
 * This automatically pings, polls, writes, and auto's the proxy extension
 * as necessary.
 *
 * @author lperkins
 *
 */
public abstract class BDdfProxyExt
  extends BProxyExt
  implements BIDdfPollable, BIDdfWritable, IDdfFacetConst
{
  /*-
   class BDdfProxyExt
   {
     properties
     {
       readParameters : BDdfIdParams
         -- Provides information to the read request telling it how to retrieve the
         -- value for this proxy and all other proxy's under the same device with the
         -- equivalent readParameters. This is fundamental to the developer driver framework's
         -- auto-poll behavior, especially for its ability to automatically group multiple
         -- proxies into the same request on the field-bus whenever possible.
         -- The default value needs to extend BDdfReadParams or implement BIDdfReadParams.
         default{[new BDdfIdParams()]}
         slotfacets{[DdfFacets.MGR_INCLUDE]}
       writeParameters : BDdfIdParams
         -- Provides information to the write request telling it how to update the
         -- value in the field-device for this proxy and all other proxy's under the same device with the
         -- equivalent writeParameters. This is fundamental to the developer driver framework's
         -- auto-write behavior, especially for its ability to automatically group multiple
         -- proxies into the same request on the field-bus whenever possible.
         -- The default value needs to implement BIDdfWriteParams.
         default{[new BDdfIdParams()]}
         slotfacets{[DdfFacets.MGR_INCLUDE]}
       pointId : BDdfIdParams
         -- Provides information to the read response and/or the write request.
         --
         -- The driver developer can use this while coding the read response
         -- to parse the data from the received data for this particular proxy.
         --
         -- The driver developer can use this write coding the write request's
         -- toByteArray method to fill in the portion of byte array that transmits
         -- this particular point's value to the field-device.
         --
         -- Descendants need to override this property and define the default
         -- As an instance of their driver's DdfIdParams.
         default{[new BDdfIdParams()]}
         slotfacets{[DdfFacets.MGR_INCLUDE]}
     }
   }
   -*/
  /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
  /*@ $com.tridium.ddf.point.BDdfProxyExt(1793170925)1.0$ @*/
  /* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "readParameters"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>readParameters</code> property.
   * Provides information to the read request telling it
   * how to retrieve the value for this proxy and all other
   * proxy's under the same device with the equivalent readParameters. This is fundamental to the developer driver framework's auto-poll behavior, especially for its ability to automatically group multiple proxies into the same request on the field-bus whenever possible. The default value needs to extend BDdfReadParams or implement BIDdfReadParams.
   * @see com.tridium.ddf.point.BDdfProxyExt#getReadParameters
   * @see com.tridium.ddf.point.BDdfProxyExt#setReadParameters
   */
  public static final Property readParameters = newProperty(0, new BDdfIdParams(),DdfFacets.MGR_INCLUDE);

  /**
   * Get the <code>readParameters</code> property.
   * @see com.tridium.ddf.point.BDdfProxyExt#readParameters
   */
  public BDdfIdParams getReadParameters() { return (BDdfIdParams)get(readParameters); }

  /**
   * Set the <code>readParameters</code> property.
   * @see com.tridium.ddf.point.BDdfProxyExt#readParameters
   */
  public void setReadParameters(BDdfIdParams v) { set(readParameters,v,null); }

////////////////////////////////////////////////////////////////
// Property "writeParameters"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>writeParameters</code> property.
   * Provides information to the write request telling it how to update the value in the field-device for this proxy and all other proxy's under the same device with the equivalent writeParameters. This is fundamental to the developer driver framework's auto-write behavior, especially for its ability to automatically group multiple proxies into the same request on the field-bus whenever possible. The default value needs to implement BIDdfWriteParams.
   * @see com.tridium.ddf.point.BDdfProxyExt#getWriteParameters
   * @see com.tridium.ddf.point.BDdfProxyExt#setWriteParameters
   */
  public static final Property writeParameters = newProperty(0, new BDdfIdParams(),DdfFacets.MGR_INCLUDE);

  /**
   * Get the <code>writeParameters</code> property.
   * @see com.tridium.ddf.point.BDdfProxyExt#writeParameters
   */
  public BDdfIdParams getWriteParameters() { return (BDdfIdParams)get(writeParameters); }

  /**
   * Set the <code>writeParameters</code> property.
   * @see com.tridium.ddf.point.BDdfProxyExt#writeParameters
   */
  public void setWriteParameters(BDdfIdParams v) { set(writeParameters,v,null); }

////////////////////////////////////////////////////////////////
// Property "pointId"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>pointId</code> property.
   * Provides information to the read response and/or the
   * write request. The driver developer can use this while
   * coding the read response to parse the data from the
   * received data for this particular proxy. The driver
   * developer can use this write coding the write request's
   * toByteArray method to fill in the portion of byte array that transmits this particular point's value to the field-device. Descendants need to override this property and define the default As an instance of their driver's DdfIdParams.
   * @see com.tridium.ddf.point.BDdfProxyExt#getPointId
   * @see com.tridium.ddf.point.BDdfProxyExt#setPointId
   */
  public static final Property pointId = newProperty(0, new BDdfIdParams(),DdfFacets.MGR_INCLUDE);

  /**
   * Get the <code>pointId</code> property.
   * @see com.tridium.ddf.point.BDdfProxyExt#pointId
   */
  public BDdfIdParams getPointId() { return (BDdfIdParams)get(pointId); }

  /**
   * Set the <code>pointId</code> property.
   * @see com.tridium.ddf.point.BDdfProxyExt#pointId
   */
  public void setPointId(BDdfIdParams v) { set(pointId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfProxyExt.class);

  /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BComplex
////////////////////////////////////////////////////////////////

  /**
   * Extensions may only be placed in BControlPoints.
   */
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BControlPoint ||
             parent instanceof BDdfDiscoveryGroup;
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  /**
   * Although this method is declared as final, descendants may
   * override the 'proxyExtStarted' method.
   */
  public final void started()
    throws Exception
  {
    super.started();
    if (getReadParameters() instanceof BIDdfReadParams)
    {
      registerToPollGroup();
    }
    proxyExtStarted();
  }

  /**
   * Although this method is declared as final, descendants may
   * override the 'proxyExtStopped' method.
   */
  public final void stopped()
    throws Exception
  {
    readUnsubscribed(null);
    if (this instanceof BIDdfPollable)
    {
      unregisterFromPollGroup();
      BDdfPollGroup.unregister(this);
    }
    super.stopped();
    proxyExtStopped();
  }

  /**
   * Although this method is declared as final, descendants may
   * override the 'proxyExtChanged' method.
   */
  public final void changed(Property property, Context context)
  {
    if (property.equals(readParameters) && isRunning())
    {
      synchronized(this)
      {
        // NOTE: The 'registeredPollGroupCode' is a cached copy of the read parameters before the change.
        BIDdfReadParams previousPollGroupCode = (BIDdfReadParams)registeredPollGroupCode;

        BIDdfReadParams newReadParams = (BIDdfReadParams)getReadParameters();

        // Checks if the change to the read parameters causes the read parameters
        // To no longer be part of the same poll group as it had been. NOTE: The poll
        // Group code is a copy of the read parameters object that is shared amongst
        // All proxies whose readParameters object group with each other. In other words,
        // Calling the 'groupWith' method on all of the proxy's readParameters object
        // Returns true for them all
        if (!previousPollGroupCode.groupWith(newReadParams))
        {
          // NOTE: Synchronizing is important to prevent any other operations accessing
          // The poll group code while it is changing.
          boolean wasReadSubscribed = isReadSubscribed; // Determines if this point was subscribed for reading, before the change that just occurred

          if (wasReadSubscribed)                 // If point was subscribed for reading
          {
            try
            {                                 // Then we unsubscribe the point for reading
              readUnsubscribed(context);
            }
            catch(Exception e)
            {
              getDdfCommunicator().getLog().error(DdfPointLexicon.errorChangingReadRequestId(this),e);
            }
          }
          try
          {
            unregisterFromPollGroup();            // Unregisters from this points poll group (since the change to the read parameters structure also changes the poll group code)
          }
          catch(Exception e)
          {
            getDdfCommunicator().getLog().error(DdfPointLexicon.errorChangingReadRequestId(this),e);
          }
          try
          {
            registerToPollGroup();                // Registers to the poll group for the new read parameters
          }
          catch(Exception e)
          {
            getDdfCommunicator().getLog().error(DdfPointLexicon.errorChangingReadRequestId(this),e);
          }
          if (wasReadSubscribed)                 // If the point was subscribed for reading
          {
            try
            {
              readSubscribed(context);           // The let's subscribe it again now that we have registered a new code
            }
            catch(Exception e)
            {
              getDdfCommunicator().getLog().error(DdfPointLexicon.errorChangingReadRequestId(this),e);
            }
          }
        }
      }
    }
    super.changed(property,context);

    proxyExtChanged(property,context);
  }

////////////////////////////////////////////////////////////////
// BProxyExt
////////////////////////////////////////////////////////////////

  /**
   * This method is called when a write to the device
   * fails for any reason.
   */
  public void writeFail(String cause)
  {
    if (logWriteFail())
    {
      getDdfCommunicator().getLog().error(getSlotPath().toDisplayString()+' '+getParentPoint().getOutStatusValue()+" to "+getWriteValue()+' '+cause);
    }
    super.writeFail(cause);
  }

  /**
   * This callback is made when a write is desired based on the
   * current status and tuning. This method posts a Runnable
   * to the network's background processor thread. The Runnable
   * then calls this object's doWrite or doAuto method from the
   * background processor thread, where it is safe to perform
   * foreign communication.
   *
   * @return false always.
   */
  public boolean write(Context cx)
    throws Exception
  {

    if (getMode()!=BReadWriteMode.readonly)
    {
      BDdfNetwork network = (BDdfNetwork)getNetwork();
      final BStatusValue out = getWriteValue();
      if(out.getStatus().isNull()) // If the write value's status is null, then the point has been auto'ed
      { // Generates a trace to the ddf communicator's log (if it's trace is on)
        if (getDdfDevice().getDdfCommunicator().getLog().isTraceOn())
          getDdfDevice().getDdfCommunicator().getLog().trace(
            DdfPointLexicon.auto + '<'+this+">:"+out);
        try
        { // Calls the doAuto method on a background thread
          network.getBackgroundProcessor().processInBackground(
            new Runnable(){
              public void run(){
                doAuto();
              }
            });
        }
        catch (Exception e)
        { // Mimics BasicDriver's fix for issue 7599
          writeFail(DdfPointLexicon.postAutoFail+":"+e);
          getDdfDevice().getDdfCommunicator().getLog().error(
            getSlotPath().toString()+':'+DdfPointLexicon.postAutoFail, e);
        }
      }
      else // If the write value's status is not null, then the driver needs to perform communication to update the
      {    // Point's value.
        // Generates a trace to the ddf communicator's log (if it's trace is on)
        if (getDdfDevice().getDdfCommunicator().getLog().isTraceOn())
          getDdfDevice().getDdfCommunicator().getLog().trace(
            DdfPointLexicon.write + '<'+this+">:"+out);

        // Post writes on the coalescing request queue!
        try
        { // Calls the doWrite method on a background thread
          network.getBackgroundProcessor().processInBackground(
            new Runnable(){
              public void run(){
                doWrite(out);
              }
            });
        }
        catch (Exception e)
        { // Mimics BasicDriver's fix for issue 7599
          writeFail(DdfPointLexicon.postWriteFail+":"+e);
          getDdfDevice().getDdfCommunicator().getLog().error(
            getSlotPath().toString()+':'+DdfPointLexicon.postWriteFail, e);
        }
      }
    }

    // Always return false - fixes basicDriver's issue 7843 (no writePending flags set)
    return false;
  }

  /**
   * This callback is made when the point enters a subscribed
   * state based on the current status and tuning.  The driver
   * should register for changes or begin polling.  Any IO should
   * be done asynchronously on another thread - never block the
   * calling thread.  The result of reads should be to call the
   * readOk() or readFail() method.
   */
  public synchronized void readSubscribed(Context cx)
    throws Exception
  {
    // NOTE: Synchronizing is important to prevent any other operations accessing
    // The poll group code while it is changing.

    // Descendants aren't necessarily pollable, let's check if the
    // Descendant has specified a requestId.
    if (!(getReadParameters().getType() == BDdfIdParams.TYPE))
    {
      BDdfPollGroup.readSubscribed((BIDdfPollable)this,cx);
      isReadSubscribed=true;
    }
  }

  /**
   * This callback is made when the point exits the subscribed
   * state based on the current status and tuning.  The driver
   * should unregister for changes of cease polling.  Any IO should
   * be done asynchronously on another thread - never block the
   * calling thread.
   */
  public synchronized void readUnsubscribed(Context cx)
    throws Exception
  {
    // NOTE: Synchronizing is important to prevent any other operations accessing
    // The poll group code while it is changing.

    // Descendants aren't necessarily pollable, let's check if the
    // Descendant has customized the 'Read Parameters'.
    if (getReadParameters().getType() != BDdfIdParams.TYPE)
    {
      BDdfPollGroup.readUnsubscribed((BIDdfPollable)this,cx);
      isReadSubscribed=false;
    }
  }

  /**
   * Provides a reasonable default implementation. If under a writable point then
   * this returns BReadWriteMode.readWrite. Otherwise this proxy is under a control
   * point that is not a Writable so this method returns BReadWriteMode.readOnly.
   */
  public BReadWriteMode getMode()
  {
    return getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
  }

  /**
   * This is an override point to allow descendant classes to override
   * the default behavior of the BBasicProxyExt.writeFail method.
   * @return true.
   */
  protected boolean logWriteFail()
  {
    return true;
  }


  public BFacets getFacets()
  {
    return getPointFacets();
  }

////////////////////////////////////////////////////////////////
// BIDdfPollable
////////////////////////////////////////////////////////////////

  public Type getReadRequestType()
  {
    return ((BIDdfReadParams)getReadParameters()).getReadRequestType();
  }

  public synchronized Object getPollGroupCode()
  {
    // NOTE: Synchronizing is important to prevent any other operations accessing
    // The poll group code while it is changing.
    return registeredPollGroupCode; // Returns the poll group code that was computed during registration to the poll group, to ensure that registration and unregistration succeeds even if the read parameters change
  }

  public BIDdfCommunicator getDdfCommunicator()
  {
    return getDdfDevice().getDdfCommunicator();
  }

  /**
   * Automatically creates an an instance of BIDdfReadRequest to be placed on the ddf
   * communcator. The ddf communicator can 'transmit' the serialized data from that
   * BIDdfRequest onto the field-bus and make callbacks to that BIDdfReadRequest object
   * when the response is receive or timed out.
   *
   * This is automatic behavior. To take advantage of this, the driver developer needs
   * to simply define the readParameters of the descendant proxy ext class. The readParameters specifies
   * the read request type. The default behavior will be to instantiate an object of the
   * read request type, assign it the response timeout from the ddf communicator's
   * receiver, assign it the initial remainingReturnCount from the ddf communicator's
   * transmitter, assign it the deviceId from the proxy's device, assign it
   * a copy of the proxy's readParameters, if the read request is also a ping request
   * then assign it's pingableSource as all devices with the equivalent deviceId,
   * and then return resulting read request.
   */
  public BIDdfReadRequest makePollRequest()
  {
    Type ddfReadRequestType = getReadRequestType();
    // Instantiates an empty instance of the appropriate type of read request
    BIDdfReadRequest ddfReadRequest = (BIDdfReadRequest)ddfReadRequestType.getInstance();

    ddfReadRequest.setResponseTimeout(getDdfCommunicator().getDdfReceiver().getResponseTimeout());
    ddfReadRequest.setRemainingRetryCount(getDdfCommunicator().getDdfTransmitter().getMaxRetryCount());

    // Sets the deviceId
    ddfReadRequest.setDeviceId((BDdfIdParams)getDdfDevice().getDeviceId().newCopy());

    // Sets the read parameters
    ddfReadRequest.setReadParameters((BDdfIdParams)getReadParameters().newCopy());

    // If the poll request happens to also be capable of acting as a ping request
    if (ddfReadRequest instanceof BIDdfPingRequest)
    {
      // Then this configures it to call pingOk or pingFail on the device and to update the device's deviceId
      ((BIDdfPingRequest)ddfReadRequest).setPingableSource(
        new IDdfPingable[]{getDdfDevice()});
    }
    return ddfReadRequest;
  }

////////////////////////////////////////////////////////////////
// BIDdfWritable
////////////////////////////////////////////////////////////////

  public Type getWriteRequestType()
  {
    if (getWriteParameters() instanceof BIDdfWriteParams)
      return ((BIDdfWriteParams)getWriteParameters()).getWriteRequestType();
    else
      return null;
  }

  /**
   * Automatically creates an an instance of BIDdfWriteReqeust to be placed on the ddf
   * communcator to reqlinquish control of the point from Niagara. The ddf communicator can
   * 'transmit' the serialized data from that BIDdfRequest onto the field-bus and make callbacks
   * to that BIDdfWriteRequest object when the response is receive or timed out.
   *
   * This is automatic behavior. To take advantage of this, the driver developer needs
   * to simply define the writeParameters of the descendant proxy ext class. The writeParameters specifies
   * in turn the auto-request types. The default behavior will be to instantiate an object of
   * the first type that is returned in the getDdfAutoRequestTypes() method of the writeParameters.
   */
  public BIDdfWriteRequest makeAutoRequest()
  {
    return makeWriteRequest(true);
  }

  /**
   * Automatically creates an an instance of BIDdfWriteReqeust to be placed on the ddf
   * communcator. The ddf communicator can 'transmit' the serialized data from that
   * BIDdfRequest onto the field-bus and make callbacks to that BIDdfWriteRequest object
   * when the response is receive or timed out.
   *
   * This is automatic behavior. To take advantage of this, the driver developer needs
   * to simply define the writeParameters of the descendant proxy ext class. The writeParameters specifies
   * in turn the write request types. The default behavior will be to instantiate an object of
   * the first type that is returned in the getDdfWriteRequestTypes() method of the writeParameters.
   */
  public BIDdfWriteRequest makeWriteRequest()
  {
    return makeWriteRequest(false);
  }

////////////////////////////////////////////////////////////////
// BDdfProxyExt
////////////////////////////////////////////////////////////////

  public BDdfDevice getDdfDevice()
  {
    return (BDdfDevice)getDevice();
  }

  /**
   * This is called from the Niagara AX started callback. Descendants can
   * safely extend this without having to call super.
   */
  protected void proxyExtStarted()
  {
  }


  /**
   * This is called from the Niagara AX stopped callback. Descendants can
   * safely extend this without having to call super.
   */
  protected void proxyExtStopped()
  {
  }

  /**
   * This is called from the Niagara AX changed callback. Descendants can
   * safely extend this without having to call super.
   */
  protected void proxyExtChanged(Property property, Context context)
  {
  }

////////////////////////////////////////////////////////////////
// BDdfProxyExt - Auto Write Mechanism
////////////////////////////////////////////////////////////////

  /**
   * Called by makeDdfWriteRequest and makeDdfAutoRequest
   * @param isAuto, true if called by makeDdfAutoRequest; false if
   * called by makeDdfWriteRequest
   * @return
   */
  private BIDdfWriteRequest makeWriteRequest(boolean isAuto)
  {
    Type ddfRequestType = (isAuto)?
                            getAutoRequestType():
                            getWriteRequestType();

    if (ddfRequestType==null)
      return null;
    else
    {
      // Instantiates an empty instance of the appropriate type of write request
      BIDdfWriteRequest ddfRequest = (BIDdfWriteRequest)ddfRequestType.getInstance();

      ddfRequest.setResponseTimeout(getDdfCommunicator().getDdfReceiver().getResponseTimeout());
      ddfRequest.setRemainingRetryCount(getDdfCommunicator().getDdfTransmitter().getMaxRetryCount());

      // Sets the deviceId
      ddfRequest.setDeviceId((BDdfIdParams)getDdfDevice().getDeviceId().newCopy());

      // Sets the write parameters structure
      ddfRequest.setWriteParameters((BDdfIdParams)getWriteParameters().newCopy());

      if (ddfRequest instanceof BIDdfReadRequest)
        ((BIDdfReadRequest)ddfRequest).setReadParameters((BDdfIdParams)getReadParameters().newCopy());

      // Adds this point as the writable source
      setWritableSource(ddfRequest);

      return ddfRequest;
    }
  }

  private void setWritableSource(BIDdfWriteRequest ddfWriteRequest)
  {
    ddfWriteRequest.setWritableSource(new IDdfWritable[]{this});
    /*
    BDdfIdParams writeParameters = getWriteParameters();
    Array writableSource = new Array(IDdfWritable.class);

    // Adds this proxy ext first, the first item is understood to be the one
    // Whose value is to be written. This is just how the Developer Driver works.
    writableSource.add((IDdfWritable)this);

    // Gets all points under the point device ext
    BControlPoint[] devicePoints = getDeviceExt().getPoints();

    // Loops through all points under the point device ext
    for (int i=0; i<devicePoints.length; i++)
    {
      // Sanity check - Only looks at those that have ddf Proxy Ext's
      if (devicePoints[i].getProxyExt() instanceof BDdfProxyExt)
      {
        // This proxy was already added to the writable source, there's no need to add it again!
        if (devicePoints[i].getProxyExt()!=this)
        {
          // If the proxy's writeValue's status is ok
          if (((BDdfProxyExt)devicePoints[i].getProxyExt()).getWriteValue().getStatus().isOk())
          {
            // If the point's ddf proxy ext's writeParameters is equivalent to this particular proxy's
            if (((BDdfProxyExt)devicePoints[i].getProxyExt())
              .getWriteParameters().equivalent(writeParameters))
            {
              // If the proxy's pointId is the same as this proxy's then that is bad ...
              // We can't write two points with the same pointId
              writableSource.add((IDdfWritable)devicePoints[i].getProxyExt());
            }
          }
        }
      }
    }
    // Assigns the writable source objects to the write request.
    ddfWriteRequest.setWritableSource((IDdfWritable[])writableSource.trim());
    */
  }

  public Type getAutoRequestType()
  {
    if (getWriteParameters() instanceof BIDdfAutoParams)
      return ((BIDdfAutoParams)getWriteParameters()).getAutoRequestType();
    else
      return null;
  }

  /**
   * This method is called when all control logic is relinquished
   * for this point in the event that there is no fallback value.
   * It allows the driver to take special action to inform the foreign
   * equipment that the particular point is no longer under control
   * of Niagara AX. Please note that not all protocols support this.
   *
   * If a protocol does not support 'auto'ing a point, then this method
   * should not be implemented.
   */
  public void doAuto()
  { // Processes writing in a generic fashion, to allow proxies and
    // Phantom points to use the same source code for writing.
    DdfWriteRequestUtil.doAuto(this);
  }

  /**
   * This callback from asynchronous thread to send a write to the device.
   * Can be implemented by subclasses!
   *
   * @param BStatusValue out is the value to be sent to the foreign hardware
   */
  public void doWrite(BStatusValue out)
  { // Processes writing in a generic fashion, to allow proxies and
    // Phantom points to use the same source code for writing.
    DdfWriteRequestUtil.doWrite(this,out);
  }

////////////////////////////////////////////////////////////////
//BDdfProxyExt - Auto Poll Mechanism
////////////////////////////////////////////////////////////////

  private synchronized void registerToPollGroup()
    throws Exception
  {
    // NOTE: Synchronizing is important to prevent any other operations accessing
    // The poll group code while it is changing.
    registeredPollGroupCode = lookupPollGroupCode();
    BDdfPollGroup.register(this);
  }

  private synchronized void unregisterFromPollGroup()
    throws Exception
  {
    // NOTE: Synchronizing is important to prevent any other operations accessing
    // The poll group code while it is changing.
    BDdfPollGroup.unregister(this);

    // Cleans up the global table of poll group codes that are equivalent
    // To the proxy's read parameters structure
    cleanReadParametersTable();

    registeredPollGroupCode=null;
  }

  @SuppressWarnings("rawtypes")
  private ArrayList getAllKnownDifferentReadParametersForDevice()
  {
    // Gets the device for this proxy
    BDdfDevice d = getDdfDevice();

    // Prepares to get an array of all known, different read parameter for the device
    ArrayList uniqueReadParamsForDevice = null;

    // Synchronizes on the readParametersForDevices hashtable for thread safety. We don't want two threads
    // Of excecution to simultaneously add an array for the same device. I don't intend for that to happen anyway,
    // But if it does then this is prepared by preventing simultaneous access to readParametersForDevices.
    synchronized(readParametersForDevices)
    {
      // Gets an array of all unique read parameters for the device
      uniqueReadParamsForDevice = readParametersForDevices.get(d);

      // If there is not yet an array of read parameters for the device then this creates one and adds it to the hashtable
      if (uniqueReadParamsForDevice==null)
      {
        uniqueReadParamsForDevice = new ArrayList<>();
        readParametersForDevices.put(d,uniqueReadParamsForDevice);
      }
    }
    return uniqueReadParamsForDevice;

  }

  /**
   * The poll group code is fundamental to the ddf. All proxy
   * points whose data can be retrieved in the same poll response should return
   * the same reference from this method.
   */
  @SuppressWarnings({"rawtypes", "unchecked"})
  private Object lookupPollGroupCode()
  {
    // Gets the read parameters structure for this proxy
    BDdfIdParams readParameters = getReadParameters();

    // Gets an array of all known, unique read parameter's for the device
    ArrayList uniqueReadParamsForDevice = getAllKnownDifferentReadParametersForDevice();

    // Synchronizes on the uniqueReadParamsForDevice array, for thread safety. We don't want two threads of execution
    // To simultaneously add a read parameter to the Array for an equivalent read parameters structure. I don't intend for this to
    // Happen anyway, but if it does then this is prepared by preventing simultaneous access to uniqueReadParamsForDevice.
    synchronized(uniqueReadParamsForDevice)
    {
      // Prepares to get a unique, global instance of BDdfIdParams that is equivalent to this proxy's read parameters structure.
      BIDdfReadParams uniqueReadParamsForProxy = null;

      // Prepares to loop through the read parameters for the device, to find the unique, global instance of BDdfIdParams that is equivalent to this proxy's read parameters structure.
      int numUniqueReadParams = uniqueReadParamsForDevice.size();

      Object[] allUniqueReadParams = uniqueReadParamsForDevice.toArray();

      // Loops through the unqiue read parameters for the device, stops early if it finds one that is equivalent to this proxy's read parameters structure.
      for (int i=0; i<numUniqueReadParams && uniqueReadParamsForProxy==null; i++)
      {
        BIDdfReadParams uniqueReadParams = (BIDdfReadParams)allUniqueReadParams[i];

        // If the uniqueReadParams's groupWith method returns true when passed this proxy's read params object
        if (uniqueReadParams.groupWith((BIDdfReadParams)readParameters))
        {
          // As soon as we find a unique, read parameters structure that can group with this proxy's read parameters structure,
          uniqueReadParamsForProxy=uniqueReadParams;      // We set uniqueReadParamsForProxy to reference it. Note that this naturally terminates the for loop.
        }
      }

      if (uniqueReadParamsForProxy==null) // If this proxy's read parameters structure is not already included among the unique read parameter structures for the device
      {
        // Then we add a copy of it to be included among the unique read parameter structures for the device.
        // So that next time this method is called for any other proxy with the equivalent read parameters structure,
        // The same exact poll group code reference will be returned.
        uniqueReadParamsForProxy = (BIDdfReadParams)readParameters.newCopy();
        uniqueReadParamsForDevice.add(uniqueReadParamsForProxy);
      }

      return uniqueReadParamsForProxy;
    }
  }

  private void cleanReadParametersTable()
  {
    // Gets the unique reference of BDdfIdParams that is equivalent to this
    // Proxy's read parameters structure.
    BDdfIdParams pollGroupCode = (BDdfIdParams)getPollGroupCode();

    // Gets all points under the point device ext
    BControlPoint[] devicePoints = getDeviceExt().getPoints();

    // Determines if another point uses the same poll group code
    boolean anotherPointHasSameReadParameters = false;

    for (int i=0; i<devicePoints.length && !anotherPointHasSameReadParameters; i++)
    {
      if (devicePoints[i].getProxyExt() instanceof BDdfProxyExt)
      {
        if (((BDdfProxyExt)devicePoints[i].getProxyExt())
              .getReadParameters().equivalent(pollGroupCode))
        {
          anotherPointHasSameReadParameters=true;
        }
      }
    }

    // If no other points under the device use the same poll group code
    if (!(anotherPointHasSameReadParameters))
    {
      // Then we clean up the poll group code so that the garbage collector can clean it up
      @SuppressWarnings("rawtypes") ArrayList uniqueReadParametersForDevice = getAllKnownDifferentReadParametersForDevice();

      synchronized(uniqueReadParametersForDevice)
      {
        // Removes the poll group code (one of the unique read parameter structures) from the Array of all unique read parameter structures for the device
        uniqueReadParametersForDevice.remove(pollGroupCode);

        // If there are no more read parameter structures for the device then this cleans up the entire array so that the garbage collector can clean it up too.
        if (uniqueReadParametersForDevice.size()<1)
          readParametersForDevices.remove(getDdfDevice());
      }
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  // The readParametersForDevices table hashes devices to javax.baja.util.Array objects. Each array object
  // Contains all known, unique readParameters for the device.
  @SuppressWarnings("rawtypes") private static Hashtable<BDdfDevice, ArrayList> readParametersForDevices = new Hashtable<>();

  // Used in the logic for maintaining auto poll groups
  private boolean isReadSubscribed = false;
  private Object registeredPollGroupCode = null;

}
