/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.identify;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * This is fundamental to the developer driver framework's auto-write features.
 *
 * The driver developer should:
 *
 * 1.) Define a class that extends BDdfIdParams and implements this interface.
 *
 * 2.) Define a proxy ext class that extends BDdfProxyExt, if a suitable
 * one is not already defined. It is certainly valid to re-use a proxy ext
 * class created to take advantage of the corresponding BIDdfReadParams.
 *
 * 3.) Define a request class that extends BDdfRequest and implements
 * BIDdfWriteRequest (or that extends BDdfWriteRequest for convenience).
 *
 * 4.) Re-define the writeParameters property on the request created in step
 * three and make the default value be an instance of the class that
 * implements this interface.
 *
 * 5.) Re-define the writeParameters property on the proxy ext created in step
 * two and make the default value be an instance of the class that
 * implements this interface.
 *
* =========================================================
 * To write the value of a control point in a device in a
 * driver that is built on the ddf, the
 * ddf:
 *
 * 1.)Calls getWriteParameters on the proxy extension.
 * (getWriteParameters returns an instance of this interface)
 *
 * 2.)Calls getWriteRequestType on the instance of this
 * interface that it received in step 1.
 *
 * 3.)Instantiates an instance of the write request class
 * that corresponds to the write request type that the
 * ddf received in step 2.
 *
 * 4.)Calls setWriteParameters on the write request and passes
 * in a copy of what it received back in step 1.
 *
 * 5.)Calls setPointId on the write request and passes in a
 * copy of the BDdfIdParams object that the proxy's
 * getPointId method returns.
 *
 * 6.)Calls setDeviceId on the write request and passes in a
 * copy of the BDdfIdParams object that the proxy's
 * device's getDeviceId method returns.
 *
 * @author lperkins
 *
 * @see com.tridium.ddf.comm.req.BDdfWriteRequest
 * @see com.tridium.ddf.comm.req.BIDdfWriteRequest
 * @see com.tridium.ddf.point.BDdfProxyExt
 *
 */
public interface BIDdfWriteParams
  extends BInterface, IDdfFacetConst
{
  /**
   * The implementing class needs to return the Type that
   * represents the BIDdfWriteRequest from the driver whose
   * writeParameters can be an instance of the implementing
   * class.
   *
   * This method must not return null!
   *
   * This is fundamental to the developer driver framwork's auto-write feature that is
   * built into BDdfProxyExt
   *
   * @return review method description.
   */
  public Type getWriteRequestType();

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfWriteParams.class);
}
