/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.identify;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * This class is a convenience for developers who wish
 * to define a set of ping parameters. To ping a device
 * in a driver that is built on the ddf,
 * the ddf:
 * 
 * 1.)Calls getPingParameters on the device.
 * (getPingParameters returns an instance of this class)
 *
 * 2.)Calls getPingRequestType on the instance of this
 * class that it received in step 1.
 * 
 * 3.)Instantiates an instance of the ping request class
 * that corresponds to the ping request type that the
 * ddf received in step 2.
 * 
 * 4.)Calls setPingParameters on the ping request and passes
 * in a copy of what it received back in step 1.
 * 
 * 5.)Calls setDeviceId on the ping request and passes in a
 * copy of the BDdfIdParams object that the device's getDeviceId
 * method returns.
 * 
 * 6.) Submits the ping request onto the communicator.
 * 
 * 7.) Matches up a ping response to the ping request and 
 * automatically calls pingOk or pingFail on the appropriate
 * pingable components.
 * 
 * @see BIDdfPingParams
 * 
 * @author lperkins
 */
public abstract class BDdfPingParams
  extends BDdfIdParams
  implements BIDdfPingParams
{
  /*-
  class BDdfPingParams
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.identify.BDdfPingParams(2856548165)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfPingParams.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// BIDdfPingParams
////////////////////////////////////////////////////////////////
  
  public Type[] getPingRequestTypes()
  {
    return new Type[]{getPingRequestType()};
  }
}
