/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.identify;

import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.nre.util.Array;

import com.tridium.ddf.IDdfFacetConst;

/**
 * This interface acts as the fundamental glue between
 * Niagara AX components and developer driver framework components.
 *
 * For example, a device or proxy is associated with a ddf driver
 * request through a special subclass of this that
 * we refer to as the "deviceId".
 *
 * A device is associated with a ddf driver ping request through
 * two special subclasses of this that we refer to as the "deviceId" and
 * the "pingParameters".
 *
 * For example, a proxy extension is associated with a
 * ddf read request and write request through three
 * special sub-classes of this that we refer to as the
 * "deviceId", "readParameters", and the "writeParameters".
 *
 * The toString method of this class returns the value of the first
 * property that the driver developer adds to his or her subclass.
 *
 * @author lperkins
 */
public class BDdfIdParams
  extends BStruct
  implements IDdfFacetConst
{
  /*-
   class BDdfIdParams
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.identify.BDdfIdParams(2333666738)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfIdParams.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BObject
////////////////////////////////////////////////////////////////
  public String toString(Context context)
  { // Gets all frozen properties
    Property[] frozenProps = getFrozenPropertiesArray();
    // Prepares a buffer to help build this method's return value
    StringBuffer buf = new StringBuffer();
    // Allocates an array to store all non-hidden, frozen properties
    Array<Property> visibleProps = new Array<>(Property.class);
    // Loops through the frozen properties and pulls out those are
    // Not hidden
    for (int i=0; i<frozenProps.length; i++)
    {
      if (!Flags.isHidden(this, frozenProps[i]))
      {
        visibleProps.add(frozenProps[i]);
      }
    }
    // Loops through the non-hidden properties
    Property[] visiblePropsArray = visibleProps.trim();
    for (int i=0; i<visiblePropsArray.length; i++)
    { // Builds the return string accordingly
      buf.append(getDisplayName(visiblePropsArray[i], context)).append(' ');
      buf.append(get(visiblePropsArray[i]).toString(context));
      if (i+1<visiblePropsArray.length)
        buf.append(',');
    }
    return buf.toString();
  }

////////////////////////////////////////////////////////////////
// BDdfIdParams
////////////////////////////////////////////////////////////////

  /**
   * Determines if this instance of BDdfIdParams is an existing representation
   * of the given instance of BDdfIdParams. This is presently used by the Ddf
   * Device and Ddf Point Managers to determine whether or not to gray out a
   * discovery object's icon.
   *
   * @param other another instance of the class as this object
   * @param c a context to allow for future flexibility in the use
   * of this method.
   *
   * @return true if the given instance is a representation of the current
   * instance. This is almost an 'equivalent' check. In fact, the default
   * implementation calls the baja 'equivalent' method from BComplex. However,
   * driver developers may override this and return true or false based on
   * the driver's own criteria. This is apparent in the device/point manager
   * where the icon for a discovery object is grayed out if a corresponding
   * database object exists.
   */
  public boolean isExisting(BDdfIdParams other, Context c)
  {
    return this.equivalent(other);
  }
}
