/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.identify;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BDdfAutoDiscoveryJob makes use of this class to allow
 * it to automatically, yet generically loop through all possible
 * combinations of a driver's discovery request in order to
 * retrieve all discovery objects for a driver's Ddf Device
 * Manager or Ddf Point Manager
 *
 * This class extends BDdfIdParams and implements
 * BIDdfDiscoverParams for convenience. You can make it so that a
 * different subclass of BDdfIdParams can be used in
 * the discovery process by making it implement
 * BIDdfDiscoverParams instead of extending this class.
 *
 * @author lperkins
 *
 */
public abstract class BDdfDiscoverParams
  extends BDdfIdParams
  implements BIDdfDiscoverParams
{
  /*-
  class BDdfDiscoverParams
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.identify.BDdfDiscoverParams(390573991)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDiscoverParams.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BIDdfDiscoverParams
////////////////////////////////////////////////////////////////

  /**
   * This method is included for future extensibility. We recommend
   * that the developer return an array of size one, with the one item
   * being the same Type that is returned by the getDdfDiscoverRequestType
   * method.
   *
   * This method is used in the driver's auto-discovery feature. It allows
   * the auto-discovery mechanism to transmit multiple different discover messsages
   * for the same hypothetical discovery i.d. We envision that the
   * multiple flavors of discover messages might be used for different sub-device
   * types.
   *
   * @return review method description.
   */
  public Type[] getDiscoverRequestTypes()
  {
    return new Type[]{getDiscoverRequestType()};
  }
  
  /**
   * Generically implements this method by 'for' looping from this
   * instance to the given value, counting the number of loop iterations,
   * and returning that value. This is used to allow the ddf automatic
   * discovery mechanism to display progress.
   * 
   * @see BIDdfDiscoverParams
   */
  public int countTo(BIDdfDiscoverParams toDiscoverId)
  {
    BIDdfDiscoverParams fromDiscoverId = this;
    int numRequestsToTry=0;
    for (BIDdfDiscoverParams currentDiscoverId = fromDiscoverId, // Walks through the entire possible sequence of discover id's
         previousDiscoverId = fromDiscoverId;        // In order to count the number of iterations.
          !previousDiscoverId.isAfter(currentDiscoverId) && // We do this to allow us to increment the
          !currentDiscoverId.isAfter(toDiscoverId);        // Job progress in main loop of the discovery process
        previousDiscoverId=currentDiscoverId,
        currentDiscoverId = currentDiscoverId.getNext())
      numRequestsToTry++;
    return numRequestsToTry;
    
  }
  

}
