/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover.auto;

import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfDiscoverParams;

/**
 * This class is used to customize the "Discover" dialog that the user sees when he or she
 * clicks the "Discover" button on the Ddf Device Manager and/or the Ddf Point Manager.
 *
 * Drivers will typically need to define two classes that each extend this class. One for
 * the Ddf Device Manager and one for the Ddf Point Manager.
 *
 * In the one for the Ddf Device Manager, the default min and max needs to be a special
 * instance of BDdfIdParams created for the device discovery process. Sometimes the
 * driver's device id can be re-used as the min and max. If not, then the driver will
 * define a special class extending BDdfIdParams for the device discovery process.
 *
 * In the one for the Ddf Point Manager, the default min and max needs to be a special
 * instance of BDdfIdParams created for the point discovery process. Sometimes the
 * drivers's read parameters structure can be re-used as the min and max. If not, then
 * the driver will define a special class extending BDdfIdParams for the point discovery
 * process.
 *
 * @author lperkins
 * */
public class BDdfAutoDiscoveryPreferences
  extends BDdfDiscoveryPreferences
{
/*-
    class BDdfAutoDiscoveryPreferences
    {
      properties
      {
        timeout : BRelTime
          -- This is the amount of time to wait per field-bus request before timing out
          -- TODO: The descendant should consider overriding this property and
          -- at least change the default value!
          default{[BRelTime.makeSeconds(3)]}
          slotfacets{[BFacets.make(BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE),
                                   BFacets.MIN,BRelTime.make(0))]}
        retryCount : int
          -- This is the number of discovery field-message retransmissions
          -- per request.
          -- TODO: The descendant should consider overriding this property and
          -- at least change the default value!
          default{[1]}
          slotfacets{[BFacets.make(BFacets.MIN,BInteger.make(0))]}
        min : BDdfIdParams
          -- This identifies the "lowest" entity to attempt to learn.
          -- TODO: The descendant should override this property!
          -- The default MUST implement BIDdfDiscoverParams
          default{[new BDdfIdParams()]}
        max : BDdfIdParams
          -- This identifies the "highest" entity to attempt to learn.
          -- TODO: The descendant should override this property!
          -- The default MUST implement BIDdfDiscoverParams
          default{[new BDdfIdParams()]}
        doNotAskAgain : boolean
          -- If set to true, then the ddf device/point manager will not display
          -- The dialog that prompts the integrator for discovery parameters on
          -- Subsequent discovery attempts.
          default{[false]}
      }
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences(2347875217)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "timeout"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timeout</code> property.
   * This is the amount of time to wait per field-bus request
   * before timing out TODO: The descendant should consider
   * overriding this property and at least change the default
   * value!
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#getTimeout
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#setTimeout
   */
  public static final Property timeout = newProperty(0, BRelTime.makeSeconds(3),BFacets.make(BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE),
                                   BFacets.MIN,BRelTime.make(0)));
  
  /**
   * Get the <code>timeout</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#timeout
   */
  public BRelTime getTimeout() { return (BRelTime)get(timeout); }
  
  /**
   * Set the <code>timeout</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#timeout
   */
  public void setTimeout(BRelTime v) { set(timeout,v,null); }

////////////////////////////////////////////////////////////////
// Property "retryCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>retryCount</code> property.
   * This is the number of discovery field-message retransmissions
   * per request. TODO: The descendant should consider overriding this property and at least change the default value!
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#getRetryCount
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#setRetryCount
   */
  public static final Property retryCount = newProperty(0, 1,BFacets.make(BFacets.MIN,BInteger.make(0)));
  
  /**
   * Get the <code>retryCount</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#retryCount
   */
  public int getRetryCount() { return getInt(retryCount); }
  
  /**
   * Set the <code>retryCount</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#retryCount
   */
  public void setRetryCount(int v) { setInt(retryCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "min"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>min</code> property.
   * This identifies the "lowest" entity to attempt to learn. TODO: The descendant should override this property! The default MUST implement BIDdfDiscoverParams
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#getMin
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#setMin
   */
  public static final Property min = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>min</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#min
   */
  public BDdfIdParams getMin() { return (BDdfIdParams)get(min); }
  
  /**
   * Set the <code>min</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#min
   */
  public void setMin(BDdfIdParams v) { set(min,v,null); }

////////////////////////////////////////////////////////////////
// Property "max"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>max</code> property.
   * This identifies the "highest" entity to attempt to
   * learn. TODO: The descendant should override this property!
   * The default MUST implement BIDdfDiscoverParams
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#getMax
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#setMax
   */
  public static final Property max = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>max</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#max
   */
  public BDdfIdParams getMax() { return (BDdfIdParams)get(max); }
  
  /**
   * Set the <code>max</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#max
   */
  public void setMax(BDdfIdParams v) { set(max,v,null); }

////////////////////////////////////////////////////////////////
// Property "doNotAskAgain"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>doNotAskAgain</code> property.
   * If set to true, then the ddf device/point manager will not display The dialog that prompts the integrator for discovery parameters on Subsequent discovery attempts.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#getDoNotAskAgain
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#setDoNotAskAgain
   */
  public static final Property doNotAskAgain = newProperty(0, false,null);
  
  /**
   * Get the <code>doNotAskAgain</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#doNotAskAgain
   */
  public boolean getDoNotAskAgain() { return getBoolean(doNotAskAgain); }
  
  /**
   * Set the <code>doNotAskAgain</code> property.
   * @see com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences#doNotAskAgain
   */
  public void setDoNotAskAgain(boolean v) { setBoolean(doNotAskAgain,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfAutoDiscoveryPreferences.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDdfAutoDiscoveryPreferences
////////////////////////////////////////////////////////////////
  
  /**
   * Calls getMin, casts the result to BIDdfDiscoverParams, and
   * returns whatever its getDiscoveryLeafType method returns.
   */
  public Type getDiscoveryLeafType()
  {
    return ((BIDdfDiscoverParams)getMin()).getDiscoveryLeafType();
  }
  
  /**
   * Developers may override this method if they would prefer that
   * the corrsponding user interface manager not actually submit
   * a discovery job when the 'Discover' button is clicked.
   * 
   * By default, this method returns true if the value for the 'min'
   * property is not of type BDdfIdParams.TYPE. The idea here
   * is that a discovery job will only be kicked off if the developer
   * re-definies the 'min' property with a class for their own
   * driver that extends BDdfIdParams.
   * 
   * 
   * However, if this is
   * overridden to return false then when clicked, the 'Discover'
   * button will simply place the user interface manager into
   * learn mode.
   * 
   * 
   * @return true if the corresponding user interface manager should submit
   * a discovery job in the background of the station. False if the
   * corresponding user interface should not submit a discovery job
   * in the background of the station at all (in this case, the manager
   * will still be placed into 'learn mode' to display any frozen
   * discovery objects in the discovery host's discovery folder)
   */
  public boolean getNeedsJob()
  {
    return getMin().getType() != BDdfIdParams.TYPE;
  }
}
