/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * This is the common ancestor of the Niagara AX types that appear
 * in the discovery list of the Ddf Device Manager and Ddf Point
 * Manager.
 *
 * There are two subclasses of BIDdfDiscoveryObject:
 * 1.) BIDdfDiscoveryGroup
 * 2.) BIDdfDiscoveryLeaf
 * @author lperkins
 *
 */
public interface BIDdfDiscoveryObject
  extends BInterface, IDdfFacetConst
{
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfDiscoveryObject.class);
}
