/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Discovery leaves appear in the discovery list on the
 * Ddf Device Manager or Ddf Point Manager. Ddf discovery
 * leaves are not expandable in the discovery list. They
 * do not have any child entries under themselves.
 *
 * @author lperkins
 */
public interface BIDdfDiscoveryLeaf
  extends BIDdfDiscoveryObject
{
  /**
   * When a control point is added to the station from the Ddf
   * Point Manager, it is given this name by default (possibly
   * with a suffix to make it unique).
   */
  public String getDiscoveryName();

  /**
   * Descendants need to return an array of TypeInfo objects corresponding
   * to all valid Niagara Ax types for this discovery object. This is
   * important when the end-user clicks 'Add' from the user interface for
   * the manager.
   *
   * For this discovery object, please  return a list of the types
   * which may be used to model it as a BComponent in the station
   * database. If the discovery object represents a device in your
   * driver then this method should return an array with size of
   * at least one, filled with TypeInfo's that wrap the Niagara AX
   * TYPE's for your driver's device components.
   *
   * The type at index 0 in the array should be the type which
   * provides the best mapping.  Please return an empty array if the
   * discovery cannot be mapped.
   */
  public TypeInfo[] getValidDatabaseTypes();

  /**
   * The discovery leaf should extend BComplex or at least behave as if
   * it does. For discoveries that are only one-level deep, the parent
   * of the discovery leaf will be the discovery folder that is under
   * the BIDdfDiscoveryHost or under the BDdfDiscoveryJob.
   *
   * If extending BComplex (and implementing BIDdfDiscoveryLeaf) or a
   * subclass of BComplex, the class will inherit this method automatically.
   */
  public BComplex getParent();

  /**
   * The discovery leaf should extend BComplex or at least behave as if
   * it does. The properties on the discovery leaf are matched to the
   * properties on corresponding database components by means of
   * property introspection.
   *
   * If extending BComplex (and implementing BIDdfDiscoveryLeaf) or a
   * subclass of BComplex, the class will inherit this method automatically.
   */
  public Property[] getPropertiesArray();

  /**
   * The discovery leaf should extend BComplex or at least behave as if
   * it does.
   *
   * If extending BComplex (and implementing BIDdfDiscoveryLeaf) or a
   * subclass of BComplex, the class will inherit this method automatically.
   */
  public BValue get(Property p);


  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfDiscoveryLeaf.class);
}
