/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Ddf discovery groups appear in the discovery list of
 * the Ddf Device Manager or Ddf Point Manager. Unlike
 * Ddf Discovery Leaves though, Ddf Discovery Groups are
 * exandable and can contain other ddf discovery groups
 * and/or ddf discovery leaves underneath them.
 *
 * The containment is done by adding children to
 * the ddf discovery group component (children of type BIDdfDiscoveryGroup,
 * BIDeviceDiscoveryLeaf, and/or BIPointDiscoveryLeaf.
 *
 * @author lperkins
 *
 */
public interface BIDdfDiscoveryGroup
  extends BIDdfDiscoveryObject
{

  /**
   * Extending from BComponent gives this to you for free.
   */
  public <T> T[] getChildren(Class<T> c);

  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////

  public static final Type TYPE = Sys.loadType(BIDdfDiscoveryGroup.class);
}
