/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * Discovery objects by default are placed as Niagara AX children directly
 * under this. However, if the driver wants to persist the discovery objects
 * or place them in another location for any reason, then the discovery
 * objects are placed under the discoveryFolder that is identified by the
 * discoveryFolder property.
 * 
 * @author lperkins
 */
public class BDdfDiscoveryJob
  extends BSimpleJob
  implements IDdfFacetConst
{
  /*-
  class BDdfDiscoveryJob
  {
    properties
    {
      discoveryFolder : BOrd
        -- This references the BFolder that contains the discovery objects,
        -- In case they are not stored under the job. It is equally valid to
        -- Store discovery objects on a driver's network or device.
        default{[BOrd.NULL]}
    }
    
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.discover.BDdfDiscoveryJob(3216620460)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "discoveryFolder"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>discoveryFolder</code> property.
   * This references the BFolder that contains the discovery
   * objects, In case they are not stored under the job.
   * It is equally valid to Store discovery objects on a driver's network or device.
   * @see com.tridium.ddf.discover.BDdfDiscoveryJob#getDiscoveryFolder
   * @see com.tridium.ddf.discover.BDdfDiscoveryJob#setDiscoveryFolder
   */
  public static final Property discoveryFolder = newProperty(0, BOrd.NULL,null);
  
  /**
   * Get the <code>discoveryFolder</code> property.
   * @see com.tridium.ddf.discover.BDdfDiscoveryJob#discoveryFolder
   */
  public BOrd getDiscoveryFolder() { return (BOrd)get(discoveryFolder); }
  
  /**
   * Set the <code>discoveryFolder</code> property.
   * @see com.tridium.ddf.discover.BDdfDiscoveryJob#discoveryFolder
   */
  public void setDiscoveryFolder(BOrd v) { set(discoveryFolder,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDiscoveryJob.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// BSimpleJob
////////////////////////////////////////////////////////////////
  
  /**
   * Descendants should override this method and perform some field-bus communications,
   * and populate a list of root-level discovery objects or discovery groups. The discovery
   * groups should also be populated with all sub-ordinate discovery groups or discovery
   * objects.
   */
  public void run(Context cx) throws Exception
  {
    
  }
  
////////////////////////////////////////////////////////////////
// BDdfDiscoveryJob
////////////////////////////////////////////////////////////////
  
  /**
   * Gets the root-level BIDiscoveryObjects that this job discovered. By default,
   * these are stored under this job in the Niagara AX tree. Descendants can override
   * this and pull the roots from a more permanent location such as the driver's
   * network or device, if necessary, for the driver.
   * 
   * @return
   */
  public BIDdfDiscoveryObject[] getRootDiscoveryObjects()
  {
    BComponent discoveryFolder =
      getDiscoveryFolder().equals(BOrd.NULL)?
      this : (BComponent)getDiscoveryFolder().get(this);
        
    return discoveryFolder.getChildren(BIDdfDiscoveryObject.class);
  }

  /**
   * Removes all dynamic properties from under the discovery folder.
   *
   */
  protected void clearRootDiscoveryObjects()
  {
    BComponent discoveryFolder =
      getDiscoveryFolder().equals(BOrd.NULL)?
      this : (BComponent)getDiscoveryFolder().get(this);
    
    discoveryFolder.removeAll();
  }}
