/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.discover;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * This is the default implementation of BIDdfDeviceDiscoveryLeaf.
 *
 * Your BIDdfDiscoverResponse.parseDiscoveryObjects's return array may
 * contain instances of this class. Each instance of this class represents
 * one possible device in the database.
 *
 * @see BIDdfDeviceDiscoveryLeaf
 * @author lperkins
 */
public class BDdfDeviceDiscoveryLeaf
  extends BDdfDiscoveryLeaf
  implements BIDdfDeviceDiscoveryLeaf
{
  /*-
   class BDdfDeviceDiscoveryLeaf
   {
     properties
     {
       deviceId : BDdfIdParams
         -- Defines the deviceId for a device discovery object. The Ddf Device Manager will synchronize this with the deviceId of the corresponding database device.
         default{[new BDdfIdParams()]}
       pingParameters : BDdfIdParams
         -- Defines the pingParameters for a device discovery object. The Ddf Device Manager will synchronize this with the pingParameters of the corresponding database device.
         default {[new BDdfIdParams()]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf(3064845903)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceId</code> property.
   * Defines the deviceId for a device discovery object.
   * The Ddf Device Manager will synchronize this with the deviceId of the corresponding database device.
   * @see com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf#getDeviceId
   * @see com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf#setDeviceId
   */
  public static final Property deviceId = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>deviceId</code> property.
   * @see com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf#deviceId
   */
  public BDdfIdParams getDeviceId() { return (BDdfIdParams)get(deviceId); }
  
  /**
   * Set the <code>deviceId</code> property.
   * @see com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf#deviceId
   */
  public void setDeviceId(BDdfIdParams v) { set(deviceId,v,null); }

////////////////////////////////////////////////////////////////
// Property "pingParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pingParameters</code> property.
   * Defines the pingParameters for a device discovery object. The Ddf Device Manager will synchronize this with the pingParameters of the corresponding database device.
   * @see com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf#getPingParameters
   * @see com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf#setPingParameters
   */
  public static final Property pingParameters = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>pingParameters</code> property.
   * @see com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf#pingParameters
   */
  public BDdfIdParams getPingParameters() { return (BDdfIdParams)get(pingParameters); }
  
  /**
   * Set the <code>pingParameters</code> property.
   * @see com.tridium.ddf.discover.BDdfDeviceDiscoveryLeaf#pingParameters
   */
  public void setPingParameters(BDdfIdParams v) { set(pingParameters,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDeviceDiscoveryLeaf.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
