/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.singleTransaction;

import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.comm.rsp.BIDdfMultiFrameResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.comm.rsp.IDdfTransmitAckResponse;

/**
/**
 * BDdfSingleTransactionMgr - This is an override point for
 * transaction managers on communicators that use a master-slave style protocol.
 *
 * The serial, single transaction communicator in the devSerialDriver
 * module provides a resonable implementation that already uses this class.
 * So you can probably save a ton of time by extending that communicator
 * and then you won't have to worry about the transaction manager becuase
 * it will handle it for you.
 * 
 * @author    lperkins
 * @creation  Oct 17, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BDdfSingleTransactionMgr
  extends BDdfTransactionMgr
  implements BIDdfSingleTransactionMgr
{
  /*-
  class BDdfSingleTransactionMgr
  {
  }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionMgr(969427351)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSingleTransactionMgr.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 
////////////////////////////////////////////////////////////////
// BIDdfTransactionMgr
////////////////////////////////////////////////////////////////
  public void stopTransactionMgr()
  {
    try
    {
      super.stopTransactionMgr();
    }
    finally
    {
      if (outstandingRequest!=null)
      {
        if (getDdfCommunicator().getLog().isTraceOn())
          getDdfCommunicator().getLog().trace(
              DdfDefaultCommLexicon.requestTimedOut(outstandingRequest));
        
        // Allows the user to take further action for the timeout to call readFail, etc.
        DdfRequestUtil.processTimeout(outstandingRequest);
        outstandingRequest=null;
      }
    }
  }
  
////////////////////////////////////////////////////////////////
// BDdfTransactionMgr
////////////////////////////////////////////////////////////////

  /**
   * The default implementation is suitable for a master-slave protocol.
   * This method will block until it is safe to transmit the given req.
   */
  protected void beginTransaction(BIDdfRequest req)
    throws Exception
  {
    synchronized(internalSynchronizer)
    {
//      if (outstandingRequest!=null)
//        wait();

      while(outstandingRequest!=null)

        internalSynchronizer.wait();

      
      // Checks if the transaction manager will be waiting for a response
      if (!(req.getResponseTimeout().equals(BRelTime.DEFAULT)))
        outstandingRequest = req;
    }
  }
  
  public void doCheckOutstandingTimeout(BIDdfRequest ddfRequest)
  { 
    synchronized(internalSynchronizer)
    {
      // If there is still an outstanding request and the outstanding request is the ddfRequest
      if (outstandingRequest!=null && outstandingRequest==ddfRequest)
      {
        if (ddfRequest.getRemainingRetryCount()>0)
        { 
          try
          {
            //  Then lets try again one time
            ddfRequest.setRemainingRetryCount(ddfRequest.getRemainingRetryCount()-1);
            
            getDdfCommunicator().getDdfTransmitter().forceTransmit(ddfRequest);
            
            getDdfCommunicator().getDdfTransmitter().setRetransmissionCount(
                getDdfCommunicator().getDdfTransmitter().getRetransmissionCount()+1); // Updates the retransmission count
  
          }
          catch (Exception e)
          {
            getDdfCommunicator().getLog().error("RetransmissionError",e);
          }
          finally
          {
            // And let's schedule another check for timeout
            scheduleToCheckForTimeout(ddfRequest);
          }
        }
        else // There are no (remaining) timeouts permitted. This message is timing out
        {
          try
          {
            if (getDdfCommunicator().getLog().isTraceOn())
              getDdfCommunicator().getLog().trace(
                  DdfDefaultCommLexicon.requestTimedOut(ddfRequest));
            
            // Allows the user to take further action for the timeout to call readFail, etc.
            DdfRequestUtil.processTimeout(ddfRequest);
          }
          finally
          { 
            // Allows us to stop processing this request.
            outstandingRequest = null;
            
            // Notifies in a 'finally' to guarantee that the notify happens even if the
            // 'processTimeout' method throws a runtime exception
            internalSynchronizer.notifyAll(); 
          }
        }
      }
    }
  }

  protected void frameReceived(IDdfDataFrame ddfReceiveFrame)
  {
    synchronized (internalSynchronizer)
    {
      // The frame will be considered "consumed" if the outstanding request's (if any) processReceive
      // Method returns a response or throws DdfResponseException
      boolean frameConsumed=false;
      
      if (outstandingRequest!=null)
      {
        try
        {
          BIDdfResponse ddfRsp = DdfRequestUtil.processReceive(outstandingRequest,ddfReceiveFrame);
          if (ddfRsp!=null)
          {
            frameConsumed=true;
            if (ddfRsp instanceof IDdfTransmitAckResponse)
            {
              transmitRspAckBytes((IDdfTransmitAckResponse)ddfRsp);
            }
            if (ddfRsp instanceof BIDdfMultiFrameResponse)
            { 
              // If a multiframe response was received, then this cancels the current
              // response-timeout Ticket and schedules a new one for the request. This
              // Causes the framework to wait for a fresh responseTimeout interval for
              // The next frame of the BIDdfMultiFrameResponse before retrying the transaction
              // Or possibly timing out.
              reScheduleToCheckForTimeout(outstandingRequest);  
            }
  
            // If the ddfRsp is the completed response for the outstandingRequest
            // (Not just one frame of a BIDdfMultiFrameResponse)
            if (isCompletedResponse(ddfRsp))
            {
              try
              {
                if (getDdfCommunicator().getLog().isTraceOn()) // Logs the response
                  getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.receivedResponseForRequest(outstandingRequest));
                
                // Processes the completed response
                DdfRequestUtil.processResponse(outstandingRequest,ddfRsp);
              }
              finally
              { 
                // The transaction is complete
                outstandingRequest = null;
                
                // Notifies all in a 'finally' block so that if the 'processResponse' method
                // throws a runtime exception then the notifyAll still occurs              
                internalSynchronizer.notifyAll();
              }
            }
            
          }
        }
        catch (DdfResponseException errorResponse)
        {
          try
          {
            if (errorResponse instanceof IDdfTransmitAckResponse)
            {
              transmitRspAckBytes((IDdfTransmitAckResponse)errorResponse);
            }   
            
            frameConsumed=true; // The frame was "consumed" becuase the request processed it in its processReceive method and threw a DdfResponseException
  
            // If an error response was received
            if (getDdfCommunicator().getLog().isTraceOn()) // Logs the error response
              getDdfCommunicator().getLog().trace(
                  DdfDefaultCommLexicon.receivedErrorResponseForRequest(outstandingRequest, errorResponse));
  
            // Processes the error response
            DdfRequestUtil.processErrorResponse(outstandingRequest,errorResponse);
          }
          finally
          { 
            // The transaction is complete
            outstandingRequest = null;
            
            // From within a 'finally' block, this notifies all that are waiting for the trasaction 
            internalSynchronizer.notifyAll();
          }
        }
      }
      if (!frameConsumed)
        routeToUnsolicited(ddfReceiveFrame);
    }
  }
  
////////////////////////////////////////////////////////////////
// BDdfSingleTransactionMgr
////////////////////////////////////////////////////////////////
  
  /**
   * Descendant implementations of the BDdfReceiver typically call this if
   * they need to know the request that was recently transmitted and is awaiting
   * response.
   * 
   * @return the BIDdfRequest that was last transmitted but no yet timed out, or null
   * if no message was last transmitted or if the last message that was transmitted
   * has already timed out.
   */
  public BIDdfRequest getOutstandingRequest()
  {
    return outstandingRequest;
  }  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  BIDdfRequest outstandingRequest = null;
  
  /**
   * This is being add after release so its access must be restricted for
   * API stability.
   */
  Object internalSynchronizer = new Object();
}
