/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.singleTransaction;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;

/**
 * BDdfSingleTransactionCommunicator - This is the override point for
 * communicators that use a master-slave style protocol. The devSerialDriver
 * module provides a reasonable serial implementation of this class. So if
 * your driver is serial then you should be able to save a ton of time by
 * subclassing the serial, single transasction communicator instead of this.
 *
 * @author    lperkins
 * @creation  Oct 17, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BDdfSingleTransactionCommunicator
  extends BDdfCommunicator
{
  /*-
   class BDdfSingleTransactionCommunicator
   {
     properties
     {
       transactionManager : BDdfTransactionMgr
         -- Hooks up the ddf single transaction communicator with a ddf single transaction manager.
         default{[ new BDdfSingleTransactionMgr() ]}
     }


   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionCommunicator(3370629492)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transactionManager"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transactionManager</code> property.
   * Hooks up the ddf single transaction communicator with
   * a ddf single transaction manager.
   * @see com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionCommunicator#getTransactionManager
   * @see com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionCommunicator#setTransactionManager
   */
  public static final Property transactionManager = newProperty(0, new BDdfSingleTransactionMgr(),null);
  
  /**
   * Get the <code>transactionManager</code> property.
   * @see com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionCommunicator#transactionManager
   */
  public BDdfTransactionMgr getTransactionManager() { return (BDdfTransactionMgr)get(transactionManager); }
  
  /**
   * Set the <code>transactionManager</code> property.
   * @see com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionCommunicator#transactionManager
   */
  public void setTransactionManager(BDdfTransactionMgr v) { set(transactionManager,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSingleTransactionCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
