/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.rsp;

import javax.baja.sys.BajaException;
import javax.baja.util.Lexicon;

import com.tridium.ddf.IDdfFacetConst;

/**
 * Each request that driver developers define need to return a response
 * from the request's processReceive method. However, if the driver
 * developer is able to conclude that the received frame contains an
 * error code or some other negative acknowledgement that denies the
 * requested data, then the request's processReceive method should
 * throw an instance of this exception to allow the ddf
 * to know not to bother retransmitting the request but instead, to end
 * the transaction and process it as an error response.
 * 
 * 
 * @author lperkins
 */
public class DdfResponseException
  extends BajaException
  implements IDdfFacetConst
{

  public DdfResponseException()
  {
  }

  public DdfResponseException(Throwable cause)
  {
    super(cause);
  }

  public DdfResponseException(String msg)
  {
    super(msg);
  }

  public DdfResponseException(String msg, Throwable cause)
  {
    super(msg,cause);
  }

  /**
   * Pulls the "message" from this exception class module's lexicon.
   */
  public String getLocalizedMessage()
  { 
    // The message by default is whatever "getMessage()" returns
    String msg = getMessage();
    
    if (msg == null)
    { 
      // If "getMessage" returns nothing
      Throwable cause = getCause();
      
      // Then let's see if there is a 'cause' for this exception
      if (cause!=null)
      { 
        // If so, then let's see if the 'cause' has a localized message
        msg = cause.getLocalizedMessage();
        
        // If the 'cause' has no localized message then let's use the cause's
        // toString value
        if (msg==null)
          msg = cause.toString();
      }
    }

    // If by some stroke of misfortune the msg is still null then let's use
    // This exception's class name. This could happen if both the 'message'
    // And 'cause' are null
    if (msg==null)
      msg = getClass().getName();
    
    // Attempts to look-up the msg in this exception class's module's lexicon.
    // In worst case scenario, the 'getText' method will return back the 'msg'
    // If there is no entry defined for it in the Lexicon.
    return Lexicon.make(getClass()).getText(msg);
  }
  
  
}
