/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.rsp;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Ddf responses that need to have data transmitted as a
 * result of the driver receiving the response should implement
 * this interface.
 *
 * @author lperkins
 */
public interface BIDdfTransmitAckResponse
  extends BIDdfResponse, IDdfTransmitAckResponse
{
  /**
   * The BDdfTransactionManager calls this method if it
   * receives a BIDdfTransmitAckResponse for any outstanding
   * or expired request. If this method returns a byte array
   * that is not null then the ddf transaction manager will
   * ask the ddf communicator to immediately transmit the
   * resulting bytes, ahead of any requests that might be
   * in the communicator's queue.
   */
  public byte[] getBytes();
  
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  public static final Type TYPE = Sys.loadType(BIDdfTransmitAckResponse.class);
}
