/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.rsp;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.identify.BDdfIdParams;

/**
 * Each request that driver developers define need to return a response
 * from the request's processReceive method. The response needs to either
 * implement this interface (or extend the BDdfResponse class, which
 * conveniently implements this interface).
 * 
 * @author lperkins
 */
public interface BIDdfResponse
  extends BInterface, IDdfFacetConst
{
  /**
   * Identifies the device that this response came from.
   */
  public BDdfIdParams getDeviceId();
  /**
   * Identifies the device that this response came from. This driver
   * developer should call this just after they instantiate one of 
   */
  public void setDeviceId(BDdfIdParams deviceId);
  
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfResponse.class);
}
