/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.rsp;

import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.discover.BIDdfDiscoveryObject;

/**
 * Responses such as ping responses and read responses should consider
 * implementing this interface as well. This is a fundamental part
 * of the auto-discovery feature.
 * 
 * @author lperkins
 *
 */
public interface BIDdfDiscoverResponse
  extends BIDdfResponse
{
  /**
   * The ddf calls this method when it matches the discover response
   * to the discover request. The BIDdfDiscoveryObjects that this method
   * returns will be placed into the 'Discovered' pane of the device
   * or point manager.
   * 
   *  The BIDdfDiscoveryOjbects in the return array should be BIDdfDeviceDiscoveryLeaf
   *  objects for a device discovery, BIDdfPointDiscoveryLeaf objects for a point
   *  discovery and/or BIDdfDiscoveryGroup objects.
   */
  public BIDdfDiscoveryObject[] parseDiscoveryObjects(Context c);
  
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  public static final Type TYPE = Sys.loadType(BIDdfDiscoverResponse.class);
}
