/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.rsp;

import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * Each request that driver developers define need to return a response
 * from the request's processReceive method. The response needs to either
 * implement BIDdfResponse (or extend this class, which conveniently
 * implements the interface BIDdfResponse).
 * 
 * @author lperkins
 */
public class BDdfResponse
  extends BComponent
  implements BIDdfResponse
{
  /*-
   class BDdfResponse
   {
     properties
     {
       deviceId : BDdfIdParams
         -- The device id matches up with the device id on the
         -- corresponding BIDdfRequest. The ddf
         -- usually assigns this value shortly after construction
         -- with a copy of the device id from the corresponding
         -- request. 
         default{[ new BDdfIdParams() ]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.rsp.BDdfResponse(1142258821)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceId</code> property.
   * The device id matches up with the device id on the
   * corresponding BIDdfRequest. The ddf usually assigns
   * this value shortly after construction with a copy of the device id from the corresponding request.
   * @see com.tridium.ddf.comm.rsp.BDdfResponse#getDeviceId
   * @see com.tridium.ddf.comm.rsp.BDdfResponse#setDeviceId
   */
  public static final Property deviceId = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>deviceId</code> property.
   * @see com.tridium.ddf.comm.rsp.BDdfResponse#deviceId
   */
  public BDdfIdParams getDeviceId() { return (BDdfIdParams)get(deviceId); }
  
  /**
   * Set the <code>deviceId</code> property.
   * @see com.tridium.ddf.comm.rsp.BDdfResponse#deviceId
   */
  public void setDeviceId(BDdfIdParams v) { set(deviceId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfResponse.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
