/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req.util;

import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/**
 * This class defines various attributes and methods that allows the source
 * code in other locations to remain relatively clean while providing
 * localized text.
 * 
 * @author lperkins
 *
 */
public class DdfRequestLexicon
{
  public static final Lexicon LEX = Lexicon.make(DdfRequestLexicon.class);
  
  // # For example: Please have the "Modbus" driver fixed.
  // PleaseFixDriver=Please have the "{0}" driver fixed.
  public static final String PLEASE_FIX_DRIVER = "PleaseFixDriver";
  
  // # For example: Reason: The method "ModbusForeignId.getDdfReadRequestTypes()" must return an array of Type[] for classes that extend "DdfReadRequestUtil". 
  // PleaseFixDriver.verifyTypesReason.line1=Reason: The method "{0}" must return an array of Type[] for classes that extend "{1}".
  public static final String PLEASE_FIX_DRIVER_VERIFY_TYPES_REASON_LINE1 = "PleaseFixDriver.VerifyTypesReason.Line1";
  
  // # For example: At present, "ModbusForeignId.getDdfReadRequestTypes()" just returned the following Type[] whose class does not extend "DdfReadRequestUtil": BModbusFoo 
  // PleaseFixDriver.verifyTypesReason.line2=At present, "{0}" just returned the following Type[] whose class does not extend "{1}": {2}
  public static final String PLEASE_FIX_DRIVER_VERIFY_TYPES_REASON_LINE2 = "PleaseFixDriver.VerifyTypesReason.Line2";
  

  public static String pleaseFixDriver(Type driverType)
  {
    return LEX.getText(PLEASE_FIX_DRIVER,new Object[]{driverType.getModule().getModuleName()});
  }
  
  private static String pleaseFixDriverVerifyTypesReasonLine1(String method, Type superType)
  {
    return LEX.getText(PLEASE_FIX_DRIVER_VERIFY_TYPES_REASON_LINE1,
        new Object[]{method,superType.getTypeName()});
  }
  
  private static String pleaseFixDriverVerifyTypesReasonLine2(String methodName,Type superType,Type driverType)
  {
    return LEX.getText(PLEASE_FIX_DRIVER_VERIFY_TYPES_REASON_LINE2,
        new Object[]{methodName,superType.getTypeName(),driverType.getTypeName()});
  }
  
  public static String verifyTypesError(Type driverType, String methodName, Type superType)
  {
    return
      pleaseFixDriver(driverType) + '\n'+ 
      pleaseFixDriverVerifyTypesReasonLine1(methodName,superType) + '\n' +
      pleaseFixDriverVerifyTypesReasonLine2(methodName,driverType,superType);
  }
    
  // # This message is placed in the faultCause property on a control point in the event
  // # That an attemp to read the data point fails due to a read request time-out.
  // RequestTimeout = Request Timeout
  public static final String REQUEST_TIMEOUT = "RequestTimeout";
  
  public static final String requestTimeout = LEX.getText(REQUEST_TIMEOUT);
  
  // # This message is thrown in a BajaRuntimeException and placed in standard output to
  // # Indicate to the driver developer that the processReceive method of BIDdfReadRequest
  // # Must return a BIDdfReadResponse, not just a BIDdfResponse. The value in parameter {0}
  // # Is the name of the class extending BIDdfReadRequest that is in error.
  // ReadReqMustUseReadRsp = This read request class must return a BIDdfReadResponse from its processReceive method: {0}
  public static final String READ_REQ_MUST_USE_READ_RSP = "ReadReqMustUseReadRsp";
  
  public static String readReqMustUseReadRsp(Type reqType)
  {
    return LEX.getText(READ_REQ_MUST_USE_READ_RSP, new Object[]{reqType.getTypeName()});
  }
  
  // # This message is thrown in a BajaRuntimeException and placed in standard output to
  // # Indicate to the driver developer that the processReceive method of BIDdfWriteRequest
  // # Must return a BIDdfWriteResponse, not just a BIDdfReponse. The value in parameter {0}
  // # Is the name of the class extending BIDdfWriteRequest that is in error.
  // WriteReqMustUseReadRsp = This write request class must return a BIDdfWriteResponse from its processReceive method" {0}
  public static final String WRITE_REQ_MUST_USE_READ_RSP = "WriteReqMustUseReadRsp";
  
  public static String writeReqMustUseWriteRsp(Type reqType)
  {
    return LEX.getText(WRITE_REQ_MUST_USE_READ_RSP, new Object[]{reqType.getTypeName()});
  }
}
