/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.identify.BDdfIdParams;


/**
 * IDdfPingable is the interface that ddf values implement if they are
 * pingable (such as some devices and networks that extend BDdfNetwork and BDdfDevice)
 *
 * @author    lperkins
 * @creation  Oct 9, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface IDdfPingable
  extends IDdfFacetConst
{
  /**
   * Returns the readableSource objects that this message can
   * update. The ddf will automatically call
   * this method after it instantiates an instance of particular
   * type of request. The ddf will pass in an
   * array of all database and/or discovery items to be updated.
   */
  public BDdfIdParams getDeviceId();
  
  public void setDeviceId(BDdfIdParams deviceId);

  /**
   * Called when <code>doPing()</code> is successful.  May also
   * be called when any successful communication occurs.  This
   * method is routed to <code>getHealth().pingOk()</code>.
   */
  public void pingOk();

  /**
   * Called when <code>doPing()</code> fails.  This method is
   * routed to <code>getHealth().pingFail()</code>.
   */
  public void pingFail(String cause);

}
