/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * Driver developers who wish to declare a request that will
 * retrieve one or more data point values should implement this
 * method or extend BDdfReadRequest. In the toByteArray method,
 * you should call getReadParameters() and getDeviceId() to
 * get a copy of your data point's read parameters and device id,
 * and use the information in those copies to formulate your
 * byte array.
 *
 * @author lperkins
 */
public interface BIDdfReadRequest
  extends BIDdfRequest
{
  /**
   * Gets the read parameters that distinguish one instance
   * of the request class from another instance, in addition
   * to the deviceId that BIDdfRequest already provides.
   *
   * @return
   */
  public BDdfIdParams getReadParameters();
  /**
   * Sets the read parameters that distinguishes one instance
   * of the request class from another instance, in addition
   * to the deviceId that BIDdfRequest already provides.
   */
  public void setReadParameters(BDdfIdParams requestId);
  /**
   * Returns the readableSource objects that this message can
   * update. The ddf will automatically call
   * this method after it instantiates an instance of particular
   * type of request. The ddf will pass in an
   * array of all database and/or discovery items to be updated.
   */
  public IDdfReadable[] getReadableSource();

  /**
   * Assigns the readableSource objects that this message can
   * update. Typically these will be passed to the concrete
   * descendant's constructor. If the message only reads one
   * item then the array may be of length one!
   *
   * This method is also called automatically in the
   * com.tridium.ddf.poll framework to automatically
   * poll points in drivers that are based on the ddf driver
   * framework.
   */
  public void setReadableSource(IDdfReadable[] readableSource);


  /**
   * If set to true then the ddf will automatically
   * call readOk on all readable source objects whenever a response is
   * received for this request.
   */
  public boolean getAutoReadOk();

  /**
   * If set to true then the ddf will automatically
   * call readOk on all readable source objects in the event that the
   * response to this message is received late after this request times
   * out. This behavior is sometimes desireable for protocols that support
   * multiple outstanding requests.
   */
  public boolean getAutoReadOkLate();

  /**
   * If set to true then the ddf will automatically
   * call readFail on all readable source objects in  the event that the
   * a timeout occurs while waiting for the response to this message.
   */
  public boolean getAutoReadFailOnTimeout();

  /**
   * If this method returns true then the ddf driver
   * framework will call readFail on all readable sources
   * for this message upon receipt of a response that
   * indicates an error condition.
   */
  public boolean getAutoReadFailOnError();
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  public static final Type TYPE = Sys.loadType(BIDdfReadRequest.class);
}
