/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * Driver developers who want ddf driver support
 * for ping requests but do not wish to extend
 * BDdfPingRequest may implement this interface
 * instead.
 *
 * @author lperkins
 */
public interface BIDdfPingRequest
  extends BIDdfRequest
{
  /**
   * The read parameters are extra information, in addition to the deviceId,
   * that the ping request may use to construct its byte array, etc.
   *
   * We call this readParameters instead of a pingParameterss in order to allow
   * read requests to more easily act also as ping requests whenever necessary.
   */
  public BDdfIdParams getReadParameters();
  /**
   * The read parameters are extra information, in addition to the deviceId,
   * that the ping request may use to construct its byte array, etc.
   *
   * During the auto-ping feature, the device's pingParams will be passed here. During
   * auto-discovery, this method is not called.
   */
  public void setReadParameters(BDdfIdParams requestParams);

  /**
   * If this method returns true then the ddf driver
   * framework will call pingOk on all pingable sources
   * for this message upon receipt of the response message.
   */
  public boolean getAutoPingOk();

  /**
   * If the method returns true then the ddf driver
   * framework will call pingOk on all pingable sources
   * for this message upon receipt of a response after
   * the request timesout. This is sometimes useful
   * for multiple outstanding transaction protocols.
   */
  public boolean getAutoPingOkLate();

  /**
   * If this method returns true then the ddf driver
   * framework will call pingFail on all pingable sources
   * for this message upon request timeout.
   */
  public boolean getAutoPingFailOnTimeout();

  /**
   * If this method returns true then the ddf driver
   * framework will call pingFail on all pingable sources
   * for this message upon receipt of a response that
   * indicates an error condition.
   */
  public boolean getAutoPingFailOnError();

  /**
   * Returns the pingableSources upon which to call pingOk
   * or pingFail for the request. Typically these will be
   * passed to the concrete descendant's constructor. If the
   * message only pings one item then the array may be of length
   * one!
   */
  public IDdfPingable[] getPingableSource();

  /**
   * Allows the pingableSource array to be assigned after construction.
   * @param pingableSource an array of IDdfPingable objects that
   * this request can ping.
   *
   * I wanted to move this out of the request and to a static table in
   * the ddf, however, being on the request itself
   * helps eliminate garbage-collection concerns of leaving stale references.
   */
  public void setPingableSource(IDdfPingable[] pingableSource);
  ////////////////////////////////////////////////////////////////
  // Niagara AX Type
  ////////////////////////////////////////////////////////////////
  public static final Type TYPE = Sys.loadType(BIDdfPingRequest.class);
}
