/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfIdParams;

/**
 * This is a default, base class that implements BIDdfRequest.
 *
 * @see BIDdfRequest
 *
 * @author lperkins
 */
public abstract class BDdfRequest
  extends BComponent
  implements BIDdfRequest
{
  /*-
   class BDdfRequest
   {
     properties
     {
       responseTimeout : BRelTime
         -- This is the amount of time that the BIDdfCommunicator will
         -- Wait for a response before retrying or ultimately timing out.
         default{[BRelTime.makeSeconds(BIDdfRequest.USE_DEFAULT_RESPONSE_TIMEOUT)]}
       remainingRetryCount : int
         -- This is the remaining number of retry counts that the BIDdfCommunicator
         -- Will attempt before timing out completely.
         default{[BIDdfRequest.USE_DEFAULT_RETRY_COUNT]}
       deviceId : BDdfIdParams
         -- The identifies the device that the request retrieves data from. In general,
         -- the information in the deviceId will be placed into the header to address
         -- the actual device to which the request applies.
         default{[new BDdfIdParams()]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.req.BDdfRequest(4119072338)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "responseTimeout"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>responseTimeout</code> property.
   * This is the amount of time that the BIDdfCommunicator
   * will Wait for a response before retrying or ultimately
   * timing out.
   * @see com.tridium.ddf.comm.req.BDdfRequest#getResponseTimeout
   * @see com.tridium.ddf.comm.req.BDdfRequest#setResponseTimeout
   */
  public static final Property responseTimeout = newProperty(0, BRelTime.makeSeconds(BIDdfRequest.USE_DEFAULT_RESPONSE_TIMEOUT),null);
  
  /**
   * Get the <code>responseTimeout</code> property.
   * @see com.tridium.ddf.comm.req.BDdfRequest#responseTimeout
   */
  public BRelTime getResponseTimeout() { return (BRelTime)get(responseTimeout); }
  
  /**
   * Set the <code>responseTimeout</code> property.
   * @see com.tridium.ddf.comm.req.BDdfRequest#responseTimeout
   */
  public void setResponseTimeout(BRelTime v) { set(responseTimeout,v,null); }

////////////////////////////////////////////////////////////////
// Property "remainingRetryCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>remainingRetryCount</code> property.
   * This is the remaining number of retry counts that the BIDdfCommunicator Will attempt before timing out completely.
   * @see com.tridium.ddf.comm.req.BDdfRequest#getRemainingRetryCount
   * @see com.tridium.ddf.comm.req.BDdfRequest#setRemainingRetryCount
   */
  public static final Property remainingRetryCount = newProperty(0, BIDdfRequest.USE_DEFAULT_RETRY_COUNT,null);
  
  /**
   * Get the <code>remainingRetryCount</code> property.
   * @see com.tridium.ddf.comm.req.BDdfRequest#remainingRetryCount
   */
  public int getRemainingRetryCount() { return getInt(remainingRetryCount); }
  
  /**
   * Set the <code>remainingRetryCount</code> property.
   * @see com.tridium.ddf.comm.req.BDdfRequest#remainingRetryCount
   */
  public void setRemainingRetryCount(int v) { setInt(remainingRetryCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "deviceId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceId</code> property.
   * The identifies the device that the request retrieves
   * data from. In general, the information in the deviceId
   * will be placed into the header to address the actual
   * device to which the request applies.
   * @see com.tridium.ddf.comm.req.BDdfRequest#getDeviceId
   * @see com.tridium.ddf.comm.req.BDdfRequest#setDeviceId
   */
  public static final Property deviceId = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>deviceId</code> property.
   * @see com.tridium.ddf.comm.req.BDdfRequest#deviceId
   */
  public BDdfIdParams getDeviceId() { return (BDdfIdParams)get(deviceId); }
  
  /**
   * Set the <code>deviceId</code> property.
   * @see com.tridium.ddf.comm.req.BDdfRequest#deviceId
   */
  public void setDeviceId(BDdfIdParams v) { set(deviceId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfRequest.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BDdfRequest(){}

  public BDdfRequest(BDdfIdParams deviceId)
  {
    setDeviceId((BDdfIdParams)deviceId.newCopy());
  }

  public BDdfRequest(BRelTime responseTimeout, int maxRetryCount, BDdfIdParams deviceId)
  {
    setResponseTimeout(responseTimeout);
    setRemainingRetryCount(maxRetryCount);
    setDeviceId((BDdfIdParams)deviceId.newCopy());
  }

  public BDdfRequest(BRelTime responseTimeout, int maxRetryCount)
  {
    setResponseTimeout(responseTimeout);
    setRemainingRetryCount(maxRetryCount);
  }
  
////////////////////////////////////////////////////////////////
// BIDdfRequest
////////////////////////////////////////////////////////////////
  
  /**
   * The ddf uses the return value from this method
   * to match up requests to responses. Implementing this method to return
   * a value other than null is especially important for drivers that use
   * the ddf multiple-transaction-manager to match requests to responses.
   *
   * For the simplest master-slave, serial protocols, this
   * can return null. These types of drivers should just use a
   * ddf single-transaction-manager anyway, which always matches the most
   * recently received frame with the most recently transmitted request.
   *
   * For more complicated drivers that support multiple outstanding transactions,
   * a BString that encodes the hex string that the request expects in the response
   * will be adequate.
   *
   * @return a BSimple with the same hashCode as the
   * corresponding BSimple in the BIDdfResponse.
   */
  public BSimple getTag()
  {
    return BString.DEFAULT;
  }

}
