/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.req;

import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfPingParams;


/**
 * This is a default, base class that implements BIDdfPingRequest.
 * 
 * While defining the toByteArray method, the driver developer should
 * use the pingParameters and the deviceId structures as the source of
 * the data that will be in the byte array.
 * 
 * @see BIDdfPingRequest
 * 
 * @author lperkins
 */
public abstract class BDdfPingRequest
  extends BDdfRequest
  implements BIDdfPingRequest
{
  /*-
  class BDdfPingRequest
  {
    properties
    {
       pingParameters : BDdfIdParams
         -- This is extra information about the device to ping.
         -- NOTE: During auto-ping, the device's pingParameters value is
         -- passed to this property. During auto-discovery, this
         -- property remains at its default. Therefore, driver developers
         -- are encouraged to redefine this property and specify a
         -- reasonable, default value.
         default{[new BDdfIdParams()]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.req.BDdfPingRequest(100412773)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "pingParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pingParameters</code> property.
   * This is extra information about the device to ping.
   * NOTE: During auto-ping, the device's pingParameters
   * value is passed to this property. During auto-discovery,
   * this property remains at its default. Therefore, driver
   * developers are encouraged to redefine this property
   * and specify a reasonable, default value.
   * @see com.tridium.ddf.comm.req.BDdfPingRequest#getPingParameters
   * @see com.tridium.ddf.comm.req.BDdfPingRequest#setPingParameters
   */
  public static final Property pingParameters = newProperty(0, new BDdfIdParams(),null);
  
  /**
   * Get the <code>pingParameters</code> property.
   * @see com.tridium.ddf.comm.req.BDdfPingRequest#pingParameters
   */
  public BDdfIdParams getPingParameters() { return (BDdfIdParams)get(pingParameters); }
  
  /**
   * Set the <code>pingParameters</code> property.
   * @see com.tridium.ddf.comm.req.BDdfPingRequest#pingParameters
   */
  public void setPingParameters(BDdfIdParams v) { set(pingParameters,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfPingRequest.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BDdfPingRequest()
  {
    
  }
  
  /**
   * This is a convenience contstructor to help a developer extend BDdfPingRequest
   * and pass his or her device to this constructor. This will
   * set the deviceId, pingableSource, and pingParameters based on the given ddfDevice.
   * 
   * @param ddfDevice
   */
  public BDdfPingRequest(BDdfDevice ddfDevice)
  { 
    super(ddfDevice.getDeviceId());
    
    // As a courtesy, this synchronizes the ping parameters between the
    // device and this request
    setPingParameters((BDdfIdParams)ddfDevice.getPingParameters().newCopy());
    // As a courtesy, this initializes the pingableSource of this ping
    // Request to include the given device
    setPingableSource(new IDdfPingable[]{ddfDevice});
  }
  
  /**
   * @param responseTimeout a custom time out for this request only
   * 
   * @param maxRetryCount a custom retry count for this request only
   * 
   * @param ddfDevice the deviceId, pingableSource, and pingParameters based on the given ddfDevice.
   */
  public BDdfPingRequest(BRelTime responseTimeout, int maxRetryCount, BDdfDevice ddfDevice)
  {
    super(responseTimeout, maxRetryCount, ddfDevice.getDeviceId() );
    // As a courtesy, this synchronizes the ping parameters between the
    // device and this request
    setPingParameters((BDdfIdParams)ddfDevice.getPingParameters().newCopy());
    // As a courtesy, this initializes the pingableSource of this ping
    // Request to include the given device
    setPingableSource(new IDdfPingable[]{ddfDevice});
  }  

  /**
   * @param deviceId the device id to "ping"
   * 
   * @param pingParams the extra "ping" parameters necessary to constuct the byte array.
   */
  public BDdfPingRequest(BDdfIdParams deviceId, BIDdfPingParams pingParams)
  {
    super(deviceId);
    setPingParameters((BDdfIdParams)((BDdfIdParams)pingParams).newCopy());
  }   
  /**
   * @param responseTimeout a custom time out for this request only
   * 
   * @param maxRetryCount a custom retry count for this request only
   * 
   * @param deviceId the device id to "ping"
   * 
   * @param pingParams the extra "ping" parameters necessary to constuct the byte array.
   */
  public BDdfPingRequest(BRelTime responseTimeout, int maxRetryCount, BDdfIdParams deviceId, BIDdfPingParams pingParams)
  {
    super(responseTimeout,maxRetryCount,deviceId);
    setPingParameters((BDdfIdParams)((BDdfIdParams)pingParams).newCopy());
  }   
  
////////////////////////////////////////////////////////////////
// BIDdfPingRequest
////////////////////////////////////////////////////////////////

  /**
   * @return true
   */
  public boolean getAutoPingFailOnTimeout()
  {
    return true;
  }

  /**
   * @return true
   */
  public boolean getAutoPingOk()
  {
    return true;
  }

  /**
   * @return true
   */
  public boolean getAutoPingOkLate()
  {
    return true;
  }

  /**
   * @return the IDdfPingable[] that was most recently passed to the
   * 'setPingableSource' method.
   */
  public IDdfPingable[] getPingableSource()
  {
    return pingableSource;
  }

  /**
   * @param the IDdfPingable[] that will be returned from subsequent calls
   * to the 'getPingableSource' method.
   */
  public void setPingableSource(IDdfPingable[] pingableSource)
  {
    this.pingableSource=pingableSource;
  }
  
  /**
   * @return true
   */
  public boolean getAutoPingFailOnError()
  {
    return true;
  }
  
  /**
   * This method allows developers to use their ping
   * requests as read requests too. To do this, developers
   * may make a class that extends BDdfPingRequest and
   * implements BIDdfReadRequest.
   * 
   * Drivers such as Modbus often read an arbitrary value
   * from the field-device as the <i>ping</i> mechanism
   * for the device.
   * 
   * This method satisfies the BIDdfReadRequest interface
   * to allow for the aforementioned shortcut.
   * 
   * @return getPingParameters();
   */
  public BDdfIdParams getReadParameters()
  {
    return getPingParameters();
  }
  
  /**
   * This method allows developers to use their ping
   * requests as read requests too. To do this, developers
   * may make a class that extends BDdfPingRequest and
   * implements BIDdfReadRequest.
   * 
   * Drivers such as Modbus often read an arbitrary value
   * from the field-device as the <i>ping</i> mechanism
   * for the device.
   * 
   * This method satisfies the BIDdfReadRequest interface
   * to allow for the aforementioned shortcut.
   * 
   * @return getPingParameters();
   */
  public void setReadParameters(BDdfIdParams readParameters)
  {
    setPingParameters(readParameters);
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  private IDdfPingable[] pingableSource = null;
}
