/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.multipleTransaction;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;

/**
 * This is a default override class for BDdfCommunicator's that require support for
 * multiple, simultaneously outstanding transactions on the field-bus. Concrete descendants
 * must override the Niagara AX 'transmitter' and 'receiver' properties and specify an
 * implementation.
 * 
 * The term, <i>Multiple, simultaneously outstanding transactions</i> means that the driver
 * protocol allows for a requests to be transmitted arbitrarily without first having to wait
 * for the response before transmitting the next request. Protocols that support this type of
 * communication will typically have more data in the header for the response. The extra
 * data in the header for the response allows the driver to determine which outstanding request
 * should be associated with the response. 
 *
 * The devSerialDriver module provides a very reasonable implementation of this. If your
 * driver is serial then you can save time by using:
 * <ul>
 * com.tridium.ddfSerial.comm.multipleTransaction.BDdfSerialMutCommunicator
 * </ul>
 * 
 * The devIpDriver module provides a very reasonable implementation of this. If your
 * driver communicates over IP then you can save time by using either:
 * <ol>
 * <li>com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator <b>OR</b>
 * <li>com.tridium.ddfIp.udp.comm.multipleTransaction.BDdfUdpMutCommunicator
 * </ol>
 *
 * @author    lperkins
 * @creation  Oct 10, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BDdfMultipleTransactionCommunicator
  extends BDdfCommunicator
{
  /*-
   class BDdfMultipleTransactionCommunicator
   {
     properties
     {
       transactionManager : BDdfTransactionMgr
         -- This is the mechanism that processes outstanding transactions
         default{[ new BDdfMultipleTransactionMgr() ]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionCommunicator(2542431818)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transactionManager"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transactionManager</code> property.
   * This is the mechanism that processes outstanding transactions
   * @see com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionCommunicator#getTransactionManager
   * @see com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionCommunicator#setTransactionManager
   */
  public static final Property transactionManager = newProperty(0, new BDdfMultipleTransactionMgr(),null);
  
  /**
   * Get the <code>transactionManager</code> property.
   * @see com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionCommunicator#transactionManager
   */
  public BDdfTransactionMgr getTransactionManager() { return (BDdfTransactionMgr)get(transactionManager); }
  
  /**
   * Set the <code>transactionManager</code> property.
   * @see com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionCommunicator#transactionManager
   */
  public void setTransactionManager(BDdfTransactionMgr v) { set(transactionManager,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfMultipleTransactionCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
