/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.defaultComm;

import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;

import javax.baja.nre.util.ByteBuffer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfReceiver;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;

/**
 * BDdfReceiver - Provides a default implementation. Everything in
 * this class is customizable.
 *
 * However, this framework intends that for most cases the descendant class
 * should simply have to implement the readByte, isStartOfFrame and
 * isCompleteFrame methods.
 *
 * @author    lperkins
 * @creation  Oct 17, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public abstract class BDdfReceiver
  extends BStruct
  implements BIDdfReceiver
{
  /*-
   class BDdfReceiver
   {
     properties
     {
        responseTimeout : BRelTime
          -- Descendants should redefine this property appropriately.
          -- This defines the amount of time, after transmitting a request,
          -- to wait for the response before possibly retrying. This is flagged
          -- as MGR_INCLUDE so that it can show up in the device manager for
          -- Ip Devices that define their own 'communicator' propery with the
          -- slot facet dfFacets.MGR_INCLUDE
          default{[BRelTime.makeSeconds(3)]}
          slotfacets{[ DdfFacets.combine(DdfFacets.MGR_INCLUDE,
                                          BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE),
                                          BFacets.make(BFacets.MIN,BRelTime.make(0)))]}

       numFramesReceived : long
         -- This is the elapsed, statistical number of frames that have been received from the field-bus.
         flags{readonly}
         default{[0]}
         slotfacets{[BFacets.make(BFacets.MIN, BInteger.make(0))]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.defaultComm.BDdfReceiver(174594448)1.0$ @*/
/* Generated Tue Dec 11 13:23:07 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "responseTimeout"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>responseTimeout</code> property.
   * Descendants should redefine this property appropriately.
   * This defines the amount of time, after transmitting
   * a request, to wait for the response before possibly
   * retrying. This is flagged as MGR_INCLUDE so that it
   * can show up in the device manager for Ip Devices that
   * define their own 'communicator' propery with the slot
   * facet dfFacets.MGR_INCLUDE
   * @see com.tridium.ddf.comm.defaultComm.BDdfReceiver#getResponseTimeout
   * @see com.tridium.ddf.comm.defaultComm.BDdfReceiver#setResponseTimeout
   */
  public static final Property responseTimeout = newProperty(0, BRelTime.makeSeconds(3),DdfFacets.combine(DdfFacets.MGR_INCLUDE,
                                          BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE),
                                          BFacets.make(BFacets.MIN,BRelTime.make(0))));

  /**
   * Get the <code>responseTimeout</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfReceiver#responseTimeout
   */
  public BRelTime getResponseTimeout() { return (BRelTime)get(responseTimeout); }

  /**
   * Set the <code>responseTimeout</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfReceiver#responseTimeout
   */
  public void setResponseTimeout(BRelTime v) { set(responseTimeout,v,null); }

////////////////////////////////////////////////////////////////
// Property "numFramesReceived"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>numFramesReceived</code> property.
   * This is the elapsed, statistical number of frames that have been received from the field-bus.
   * @see com.tridium.ddf.comm.defaultComm.BDdfReceiver#getNumFramesReceived
   * @see com.tridium.ddf.comm.defaultComm.BDdfReceiver#setNumFramesReceived
   */
  public static final Property numFramesReceived = newProperty(Flags.READONLY, 0,BFacets.make(BFacets.MIN, BInteger.make(0)));

  /**
   * Get the <code>numFramesReceived</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfReceiver#numFramesReceived
   */
  public long getNumFramesReceived() { return getLong(numFramesReceived); }

  /**
   * Set the <code>numFramesReceived</code> property.
   * @see com.tridium.ddf.comm.defaultComm.BDdfReceiver#numFramesReceived
   */
  public void setNumFramesReceived(long v) { setLong(numFramesReceived,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfReceiver.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BDdfReceiver()
  {
    Class<?> clazz = getClass();

    try
    {
      doTraceMethod = clazz.getMethod("doTrace",
                                      new Class<?>[]{IDdfDataFrame.class});
    }
    catch (NoSuchMethodException nsme)
    {
      doTraceMethod = null;
    }
  }


////////////////////////////////////////////////////////////////
// Spy
////////////////////////////////////////////////////////////////

  public void spy(SpyWriter out) throws Exception
  {
    out.startProps("Ddf Receiver");
    spyImpl(out);
    out.endProps();

    super.spy(out);
  }

  private void spyImpl(SpyWriter out)
  {
    out.prop("Receiving", receiving);
    out.prop("Rx State", getStateTextForSpy() );
    out.prop("Rx Buffer", spyBuffer() );
  }

  private String spyBuffer()
  {
    // Prepares a buffer to hold a text representation of the internal receive buffer
    StringBuffer spyBuffer = new StringBuffer();

    // Gets a reference directly to the internal receive buffer
    IDdfDataFrame internalBuffer = getInternalBuffer();

    if (internalBuffer != null) // Sanity check
    {
      // Gets a copy of the internal buffer just to be safe, since this method
      // is called by a different thread than the rest of the receive logic
      IDdfDataFrame spyFrameCopy = getInternalBuffer().getFrameCopy();

      // Gets the current size of the internal receive buffer copy
      int bufferSize = spyFrameCopy.getFrameSize();

      // Gets a byte array representation of the internal receive buffer copy
      byte[] internalBufferBytes = getInternalBuffer().getFrameBytes();

      // Loops through the bytes of the internal receive buffer copy
      for (int i=0; i<bufferSize; i++)
      {
        // Builds up a space-delimited Hex string in the spyBuffer StringBuffer
        spyBuffer.append(TextUtil.byteToHexString(internalBufferBytes[i]));

        // Adds a space if this is not the last byte
        if (i+1<bufferSize)
          spyBuffer.append(' ');
        // Adds a new line every 16 characters
        if (i%16==0)
          spyBuffer.append('\n');
      }

      // Returns the space-delimited Hex string that we just built
      return spyBuffer.toString();
    }
    else
    {
      return "null";
    }
  }

////////////////////////////////////////////////////////////////
// BIDdfReceiver
////////////////////////////////////////////////////////////////
  /**
   * The BIDdfReceiver interface requires that this method be implemented.
   *
   * Descendants should really only consider overwriting the doReceiveFrame
   * method instead.
   */
  public IDdfDataFrame receiveFrame()
  {
    try
    {
      IDdfDataFrame ddfDataFrame = doReceiveFrame();
      if (ddfDataFrame!=null)
      {
        if (getDdfCommunicator().getLog().isTraceOn())
          trace(ddfDataFrame);
        setNumFramesReceived(getNumFramesReceived()+1);
      }
      return ddfDataFrame;
    }
    catch (Exception e)
    {
      if ((e instanceof InterruptedIOException) ||
          (e instanceof InterruptedException))
      {
        // Does not attempt to log the error message if the exception
        // Is an 'InterruptedException' or 'InterruptedIOExcpetion'.
        // These could be thrown as a result of another thread calling
        // Thread.interrupt to stop the receiver. We don't to log this
        // As an error, since it simply means that the station is shutting
        // Down

        if (getDdfCommunicator().getLog().isTraceOn())
          getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.interrupted(),e);
      }
      else
      {
        // Gets the communicator
        BIDdfCommunicator communicator = getDdfCommunicator();

        // If the communicator is an instance of dev driver's communicator and not some significantly
        // customized developer version of a communicator..
        if (communicator instanceof BDdfCommunicator)
        {
          // If communications are enabled, then we will log the error.
          if (((BDdfCommunicator)communicator).isCommEnabled())
          {
            getDdfCommunicator().getLog().error(DdfDefaultCommLexicon.receiveError,e);
          }
          // Else, the communicator is not in a runnable state anyway so let's not allow any chance
          //       for the stdout to be bombarded with error messages
        }
        // Else, the communicator is some highly customized instance that we do not know has an 'isCommEnabled'
        //       method so let's just log the error at the risk of bombarding stdout with error messages each
        //       time a receiveFrame is attempted. If the communicator truly is shutting down then the receive
        //       frame should
        else
        {
          getDdfCommunicator().getLog().error(DdfDefaultCommLexicon.receiveError,e);
        }
      }
      try{Thread.sleep(100);}catch(Exception ee){} // Keeps the calling thread from spinning.
      return null;
    }
    finally
    {

    }
  }

  /**
   * This is called when the receive thread starts. Note that the receive thread
   * itself is in the BDdfTransactionMgr class to make it easier for the receive
   * thread to work with the transaction manager thread.
   *
   * If a subclass extends this method then it needs to call super.startReceiver().
   */
  public void startReceiver()
  {
    stopped=false;
  }

  /**
   * This is called when the receive thread stops. Note that the receive thread
   * itself is in the BDdfTransactionMgr class to make it easier for the receive
   * thread to work with the transaction manager thread.
   *
   * If a subclass extends this method then it needs to call super.stopReceiver().
   */
  public void stopReceiver()
  {
    stopped=true;
    ddfCommunicator=null;
  }

////////////////////////////////////////////////////////////////
// BDdfReceiver
////////////////////////////////////////////////////////////////

  /**
   * Descendants should override this method, and check the data received so far. If the data
   * received so far indicates that this is the beginning of a data frame then the subclass
   * should return BDdfReceiver.YES. If the data cannot possibly be the beginning of the
   * frame for the driver then the subclass should return BDdfReceiver.NO. If the descendant
   * needs more data before making a decision then it should return BDdfReciver.MAYBE.
   *
   * This is called by the default implementation of the safeDdfReceiveFrame method.
   *
   * @param frameSoFar is the IDdfDataFrame that this object is building up.
   *
   * @return BDdfReciver.YES if the bytes that are in the given frameSoFar are the start of a
   * frame. Or BDdfReceiver.NO if the bytes in the given frameSoFar cannot possibly be the start
   * of a frame. Or BDdfReciver.MAYBE if the bytes in the given frameSoFar could be the start
   * of a frame but more bytes would be required to make a definite determination.
   */
  protected abstract int isStartOfFrame(IDdfDataFrame frameSoFar);

  /**
   * Descendants should override this method, and check the data received so far. If the data
   * received so far indicates that this is a completed frame then the subclass
   * should return true. Otherwise, this method should return false so that the receiver
   * can keep receiving and buffering data.
   */
  protected abstract boolean isCompleteFrame(IDdfDataFrame frameSoFar);

  /**
   * This method is called by the receiver after the isCompleteFrame message
   * returns true.
   * @param completeFrame the complete IDdfDataFrame received
   * @return true if the completeFrame passes check sum tests, or if no check sum
   * test is necessary (data in TCP/IP messages, for example, do not alwasy require
   * a separate check sum test since checking is built into TCP/IP). False if a check
   * is necessary and the check fails.
   */
  protected abstract boolean checkFrame(IDdfDataFrame completeFrame);
  /**
   * Subclasses should override this method and return the next byte that is received
   * from the field bus. If the particular implementation does not efficiently read
   * bytes then the subclass should cache incoming data into a stream or array and
   * then return data through this method one byte at a time.
   *
   * @return the next byte received from the field bus (upgraded to a java int to avoid
   * problems with the sign bit).
   */
  protected abstract int readByte() throws Exception;

  /**
   * This method must be implemented to recognize and receive a frame of data from the field-bus.
   *
   * If overridden then this method must block and only return once a frame of data is received.
   *
   * Hopefully, the default implementation of this method will suffice. It would allow the descendant
   * to simply implement the abstract isCompleteFrame and isStartOfFrame methods.
   *
   * @return An object that implements the IDdfDataFrame interface that represents some data that was
   * just received from the field-bus.
   */
  protected IDdfDataFrame doReceiveFrame()
    throws Exception
  {
    try
    {
      receiving=true;
      resetReceiveBuffer();

      rxState = DEV_RX_STATE_SOH;
      while (rxState !=  DEV_RX_STATE_DONE)
      {
        // Asks the descendant for a byte and puts it into the receiveFrame buffer.
        readByteToBuffer();

        // If we are matching up the start of the frame
        if (rxState == DEV_RX_STATE_SOH)
        {
          // Asks the descendant if the contents of the buffer so far identify the start of a frame
          int isStartOfFrame = isStartOfFrame(receiveFrame);

          if (isStartOfFrame == YES)
            rxState = DEV_RX_STATE_DATA;
          else if (isStartOfFrame == NO)
            resetReceiveBuffer();
          // else, keep buffering, state remains DEV_RX_STATE_SOF
        }
        // If we are matching up the remainder of the frame, after the header, including data and footer
        else if (rxState == DEV_RX_STATE_DATA)
        {
          // Asks the descendant if the contents of the buffer so far identify a completed frame
          if (isCompleteFrame(receiveFrame))
          {
            if (checkFrame(receiveFrame))
            {
              rxState = DEV_RX_STATE_DONE; // Causes the while loop to exit
            }
            else
            {
              resetReceiveBuffer();
              rxState = DEV_RX_STATE_SOH;
            }
          }

        }
      }
      // Returns the internal receiveFrame buffer.
      return getInternalBuffer();
    }
    finally
    {
      receiving = false;
    }
  }

  /**
   * This method is called by the parent communicator's "resetStatistics"
   * action.
   */
  public void resetStatistics()
  {
    setNumFramesReceived(0);
  }

  /**
   * Returns a reference to the BIDdfCommunicator that owns this receiver. This
   * will be the Niagara AX Nav parent cast to BIDdfCommunicator.
   */
  public BIDdfCommunicator getDdfCommunicator()
  {
    if (ddfCommunicator == null)
      ddfCommunicator = (BIDdfCommunicator)getParent();
    return ddfCommunicator;
  }

  /**
   * Reads a byte into the internal buffer. By default, this calls readByte
   * and adds the result to this object's internal buffer.
   */
  protected void readByteToBuffer()
    throws Exception
  {
    receiveFrame.write(readByte());
  }

  /**
   * Determines the response timeout for a request.
   *
   * @param ddfRequest a request to determine the response timeout
   * for.
   *
   * @return if the request's responseTimeout returns a millisecond
   * count of BIDdfRequest.USE_DEFAULT_RESPONSE_TIMEOUT then this
   * return the response timeout from the receiver's property sheet.
   * Otherwise, this returns the response timeout from the given
   * request's slot map.
   */
  public BRelTime getResponseTimeout(BIDdfRequest ddfRequest)
  {
    if (ddfRequest.getResponseTimeout().equals(BDdfRequest.responseTimeout.getDefaultValue()))
      return getResponseTimeout();
    else
      return ddfRequest.getResponseTimeout();
  }

  /**
   * The descendants may customize if they wish. Hopefully the default implementation will
   * suffice though.
   */
  protected void resetReceiveBuffer()
  {
    receiveFrame.reset();
  }

  /**
   * Returns the internal buffer for this object. Hopefully the default implementation will
   * suffice. That would make it easier for descendants. However, descendants may customize
   * this if they wish.
   * @return
   */
  protected DdfReceiveFrame getInternalBuffer()
  {
    return receiveFrame;
  }

  /**
   * This method is called immediately after the call to isCompleteFrame(...) on this object
   * returns true.
   *
   * Descendants should override this method if it is possible to construct a BSimple tag for
   * the bytes inside the given frame. The BDdfCommunicator uses the tag to optimally feed
   * frames to the request to which the receive frame applies. If no tag is defined then the
   * BDdfCommunicator will have no choice but to pass all received frames to the request.
   *
   */
  protected BSimple computeTag(IDdfDataFrame iDdfDataFrame)
  {
    return BString.DEFAULT;
  }

  private void trace(IDdfDataFrame ddfDataFrame)
  {
    // HACK: I wish I hadn't made this method private...It makes it
    //       very ugly to trace XML responses. To hack around this
    //       and still preserve API stability, then if the receiver
    //       class has a public 'doTraceMethod(IDdfDataFrame) method'
    //       then this calls it to trace the frame.
    if (doTraceMethod != null)
    {
      try
      {
        doTraceMethod.invoke(this, new Object[]{ddfDataFrame});
        return;
      }
      catch (Exception e)
      {
        // Sets doTraceMethod to null so that we don't try this
        // again.
        doTraceMethod = null;

        // NOTE: This falls through and performs the default trace
      }
    }


    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    pw.println("RX:");
    ByteArrayUtil.hexDump(
        pw,
        ddfDataFrame.getFrameBytes(),
        0,
        ddfDataFrame.getFrameSize());
    pw.flush();
    pw.close();
    getDdfCommunicator().getLog().trace(sw.toString());
  }

  private String getStateTextForSpy()
  {
    switch(rxState)
    {
    case DEV_RX_STATE_SOH:
      return "DEV_RX_STATE_SOH";
    case DEV_RX_STATE_DATA:
      return "DEV_RX_STATE_DATA";
    case DEV_RX_STATE_DONE:
      return "DEV_RX_STATE_DONE";
    default:
      return ""+rxState;

    }
  }

////////////////////////////////////////////////////////////////
// DdfReceiveFrame
////////////////////////////////////////////////////////////////

  /**
   * DdfReceiveFrame is the class of the IDdfDataFrame object that is returned by
   * the default implementation of the safeDdfReceiveFrame method on the outer
   * instance.
   *
   * If descendants wish to perform advanced customization, they can gain
   * access to this class by calling the getInternalBuffer method on the
   * outer class. That will give them a direct reference to the internal
   * instance of this buffer that is maintained on the outer instance. By
   * gaining a direct reference in this fashion, the descendant can directly
   * add, remove, delete, etc. bytes directly from the internal buffer.
   *
   * However, descendants that can make full use of overriding the isStartOfFrame,
   * isCompleteFrame, and checkFrame method should hopefully not need to access
   * the inner instance ("the internal buffer") of this class directly. It
   * should be much easier to just override the methods that provide hints
   * as to the driver's framing (isStartOfFrame, etc).
   *
   * @author    lperkins
   * @creation  Oct 17, 2006
   * @version   $Revision$ $Date$
   * @since     Niagara 3.0
   */
  protected class DdfReceiveFrame
    extends ByteBuffer
    implements IDdfDataFrame
  {
    /**
     * Creates a DdfReceiveFrame with an initial capacity of 1/2 K, which
     * should be good enough for most cases. Since this extends ByteBuffer,
     * the internal byte array will automatically be increased, however, if
     * 1/2 K is not enough.
     */
    DdfReceiveFrame()
    {
      super(512); // Initial capacity of 1/2 K should be good enough for most cases
    }

    /**
     * Returns a direct reference to the byte array buffer for this data frame.
     *
     * Note that not all bytes are necessarily valid. Please only access bytes
     * from index zero through the index that is returned by calling the
     * 'getFrameSize' method.
     */
    public byte[] getFrameBytes()
    {
      return getBytes();
    }

    /**
     * Returns the number of valid bytes in this data frame.
     * @return the number of valid bytes in this data frame.
     */
    public int getFrameSize()
    {
      return getLength();
    }

    /**
     * Delegates to the 'computeTag' method on the BDdfReceiver.
     */
    public BSimple getFrameTag()
    {
      return computeTag(this);
    }

    /**
     * Creates a byte-per-byte copy of this data frame.
     */
    public IDdfDataFrame getFrameCopy()
    {
      DdfReceiveFrame retVal = new DdfReceiveFrame();
      retVal.write(toByteArray());
      return retVal;
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  /*
   * This is needed to permit client-side communications, as required for the video driver.
   */
  private BIDdfCommunicator ddfCommunicator;

  /**
   * Descendants may return this value from the isStartOfFrame method
   * to answer with an affirmative response.
   */
  public static final int YES = 0;
  /**
   * Descendants may return this value from the isStartOfFrame method
   * to answer with a negative response.
   */
  public static final int NO = 1;
  /**
   * Descendants may return this value from the isStartOfFrame methods
   * to answer with an ambiguous response.
   */
  public static final int MAYBE = 2;

  /**
   * Possible internal receive state.
   */
  private static final int DEV_RX_STATE_SOH = 0;

  /**
   * Possible internal receive state.
   */
  private static final int DEV_RX_STATE_DATA = 1;

  /**
   * Possible internal receive state.
   */
  private static final int DEV_RX_STATE_DONE = 2;

  /**
   * Indicates whether the startReciever method or stopReceiver
   * method was last called.
   */
  protected boolean stopped=false;

  /**
   * This is a reference to the internal receiveFrame for the BDdfReceiver.
   */
  DdfReceiveFrame receiveFrame = new DdfReceiveFrame();

  /**
   * Helps the spy page indicate whether or not the receive thread is currently
   * in the middle of receiving a data frame from the field-bus.
   */
  boolean receiving = false;

  /**
   * This is the receive thread's internal state.
   */
  int rxState = DEV_RX_STATE_SOH;

  Method doTraceMethod;
}
