/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm.defaultComm;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.IDdfDataFrame;

/**
 * BDdfNullReceiver - This is an empty receiver used to fill frozen
 * slots on BDdfCommunicator.
 * 
 * All of the functions that this class provides are syntactically correct
 * but provide no usable content.
 *
 * @author    lperkins
 * @creation  Oct 16, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BDdfNullReceiver
  extends BDdfReceiver
{
  /*-
   class BDdfNullReceiver
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.comm.defaultComm.BDdfNullReceiver(350432308)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfNullReceiver.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDdfReceiver
////////////////////////////////////////////////////////////////
  
  /**
   * @return false always
   */
  protected boolean isCompleteFrame(IDdfDataFrame frameSoFar)
  {
    return false;
  }
  
  /**
   * @return BDdfReceiver.NO always
   */
  protected int isStartOfFrame(IDdfDataFrame frameSoFar)
  {
    return BDdfReceiver.NO;
  }
  
  /**
   * Does nothing but sleep for ten seconds to keep any threads that may call this
   * from inside of a loop from consuming too much of the CPU.
   * 
   *  @return zero always
   */
  protected int readByte()
  {
    try
    {
      Thread.sleep(10000); // Keeps any thread that may call this inside of a loop from spinning
    }
    catch (InterruptedException ie)
    {
    }
    return 0;
  }
  
  /**
   * @return false always
   */
  protected boolean checkFrame(IDdfDataFrame completeFrame)
  {
    return false;
  }
  
}
