/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm;

import javax.baja.sys.BSimple;

import com.tridium.ddf.IDdfFacetConst;

/**
 * A BIDdfReceiver returns an object that implements the IDdfDataFrame
 * interface from the BIDdfReceiver's receiveFrame method. An
 * object that implements this interface essentially represents a frame
 * of raw data received from a field-bus.
 *
 * @author    lperkins
 * @creation  Oct 10, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface IDdfDataFrame
  extends IDdfFacetConst
{
  /**
   * This method returns the byte array representation of the data within this IDdfDataFrame
   * @return
   */
  public byte[] getFrameBytes();

  /**
   * This method returns an integer to indicate the number of valid bytes in the array returned by
   * the getDdfFrameBytes method.
   */
  public int getFrameSize();
  
  /**
   * The developer driver framework uses the return value from this method
   * to match up requests to responses. Implementing this method to return
   * a value other than null is especially important for drivers that use
   * the ddf multiple-transaction-manager to match requests to responses.
   *
   * For the simplest master-slave, serial protocols, this
   * can return null. These types of drivers should just use the
   * single-transaction-manager anyway, which always matches the most
   * recently received frame with the most recently transmitted request.
   *
   * For more complicated drivers that support multiple outstanding transactions,
   * a BString that encodes the hex string that the request expects in the response
   * will be adequate.
   *
   * @return a BSimple with the same hashCode as the
   * corresponding BSimple in the BIDdfResponse.
   */
  public BSimple getFrameTag();

  /**
   * The implementing class needs to define this method and
   * return a copy of itself. This is basically a clone.
   */
  public IDdfDataFrame getFrameCopy();
}
