/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * BIDdfUnsolicitedMgr -Niagara AX objects that process unsolicited
 * received frames should implement this interface and be added as a
 * property to the driver's communicator. 
 *
 * @author    lperkins
 * @creation  Oct 18, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public interface BIDdfUnsolicitedMgr
  extends BInterface, IDdfFacetConst
{
  /**
   * Adds an unsolicited message to the unsolicited mgr queue.
   * @param unsolicitedFrame
   */
  public void enqueueUnsolicitedFrame(IDdfDataFrame unsolicitedFrame);
  
  /**
   * Gets the communicator component that owns this unsolicited mgr.
   * @return the communicator component that owns this unsolicited mgr.
   */
  public BIDdfCommunicator getDdfCommunicator();
  
  /**
   * This method is called to start any threads that the unsolicited manager
   * uses.
   */
  public void startUnsolicitedMgr();
  
  /**
   * This method is called to stop any threads that the unsolicited manager
   * uses.
   */
  public void stopUnsolicitedMgr();
  
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  public static final Type TYPE = Sys.loadType(BIDdfUnsolicitedMgr.class);
}
