/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf.comm;

import javax.baja.sys.BInterface;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;

/**
 * The BIDdfReceiver receives frames for the BIDdfCommunicator.
 * 
 * Instead of implementing this directly, there are a wealth of implementations that can be extends.
 * These are in the packages:
 * <OL>
 *   <LI>com.tridium.ddf.comm.defaultComm
 *   <LI>com.tridium.ddf.comm.multipleTransaction
 *   <LI>com.tridium.ddf.comm.singleTransaction
 * </OL>
 * In additon, there reasonable serial versions of these in the devSerialDriver module.
 * 
 * There are reasonable Tcp/Ip versions of these in the devTcpDriver module.
 * @author lperkins
 */
public interface BIDdfReceiver
    extends BInterface, IDdfFacetConst
{
  /**
   * The implementor should make this method block the calling thread until an IDdfDataFrame
   * is received from the field-bus.
   * @return the IDdfDataFrame that is received from the field-bus. Returning null can cause the receive thread to spin lock the cpu.
   */
  public IDdfDataFrame receiveFrame();
  
  /**
   * The implementor should make this method return the BIDdfCommunicator that owns this BIDdfReceiver.
   */
  public BIDdfCommunicator getDdfCommunicator();
  /**
   * The implementor should return the default, response timeout for received frames on the field-bus.
   */
  public BRelTime getResponseTimeout();
  
  /**
   * This called when the receive thread is started.
   */
  public void startReceiver();
  
  /**
   * This called when the receive thread is stopped.
   */
  public void stopReceiver();
  
////////////////////////////////////////////////////////////////
//Type
////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfReceiver.class);
}
