/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf
;

import javax.baja.agent.AgentList;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.sys.BIService;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

/**
 * Subclassing this class makes it easy for drivers add a network to the Niagara AX framework.
 *
 * @author    lperkins
 * @creation  Oct 9, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public abstract class BDdfNetwork
  extends BLoadableNetwork
  implements IDdfFacetConst, BIService
{
  /*-
   class BDdfNetwork
   {
     properties
     {
       tuningPolicies: BTuningPolicyMap
         -- A container for tuning policies which determines how
         -- and when proxy points are read and written.
         default {[ new BTuningPolicyMap() ]}
       backgroundProcessor : BDdfWorker
         -- This is a general queue and thread combo that
         -- Is used to perform work in the background of
         -- The station
         default{[ new BDdfWorker() ]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.BDdfNetwork(1178115707)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "tuningPolicies"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tuningPolicies</code> property.
   * A container for tuning policies which determines how
   * and when proxy points are read and written.
   * @see com.tridium.ddf.BDdfNetwork#getTuningPolicies
   * @see com.tridium.ddf.BDdfNetwork#setTuningPolicies
   */
  public static final Property tuningPolicies = newProperty(0, new BTuningPolicyMap(),null);
  
  /**
   * Get the <code>tuningPolicies</code> property.
   * @see com.tridium.ddf.BDdfNetwork#tuningPolicies
   */
  public BTuningPolicyMap getTuningPolicies() { return (BTuningPolicyMap)get(tuningPolicies); }
  
  /**
   * Set the <code>tuningPolicies</code> property.
   * @see com.tridium.ddf.BDdfNetwork#tuningPolicies
   */
  public void setTuningPolicies(BTuningPolicyMap v) { set(tuningPolicies,v,null); }

////////////////////////////////////////////////////////////////
// Property "backgroundProcessor"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>backgroundProcessor</code> property.
   * This is a general queue and thread combo that Is used
   * to perform work in the background of The station
   * @see com.tridium.ddf.BDdfNetwork#getBackgroundProcessor
   * @see com.tridium.ddf.BDdfNetwork#setBackgroundProcessor
   */
  public static final Property backgroundProcessor = newProperty(0, new BDdfWorker(),null);
  
  /**
   * Get the <code>backgroundProcessor</code> property.
   * @see com.tridium.ddf.BDdfNetwork#backgroundProcessor
   */
  public BDdfWorker getBackgroundProcessor() { return (BDdfWorker)get(backgroundProcessor); }
  
  /**
   * Set the <code>backgroundProcessor</code> property.
   * @see com.tridium.ddf.BDdfNetwork#backgroundProcessor
   */
  public void setBackgroundProcessor(BDdfWorker v) { set(backgroundProcessor,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BLoadableNetwork
////////////////////////////////////////////////////////////////
  
  /**
   * This provides a reasonable default implementation of the 'postAsync'
   * method, which is required by the ancestor class BLoadableNetwork.
   * 
   * This places the the given Runnable on the background processor. 
   * 
   * @return null always
   */
  public IFuture postAsync(Runnable r)
  { // Kicks off the given runnable on the ddf network's background thread
    getBackgroundProcessor().processInBackground(r);
    return null;
  }
  
////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  /**
   * Gets the agent list.  Adds BDdfDeviceManager as "Your Driver Device Manager" if one
   * not already registered.
   *
   * @see DdfAgentInfo.getAgentsHelp
   */
  public AgentList getAgents(Context cx)
  {
    return DdfAgentInfo.getAgentsHelp(
        super.getAgents(cx),
        getType().getTypeInfo().getModuleName(),
        "devDriver:DdfDeviceManager",
        "DeviceManager",
        "Device Manager");

  }
  
////////////////////////////////////////////////////////////////
//BIService
////////////////////////////////////////////////////////////////

  public Type[] getServiceTypes()
  {
    return new Type[] { getType() };
  }

  public void serviceStarted()
    throws Exception
  {
  }
  
  public void serviceStopped()
    throws Exception
  {
  }
  
}
