/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf;

import javax.baja.driver.BDevice;
import javax.baja.driver.loadable.BLoadableDevice;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.nre.util.Array;

import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfNullCommunicator;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfPingParams;

/**
 * BDdfDevice
 *
 * If this device has its own dedicated BDdfCommunicator then you should simply indicate this by
 * making it implement the interface BIDdfCommunicating.
 *
 * @author    lperkins
 * @creation  Oct 9, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public abstract class BDdfDevice
  extends BLoadableDevice
  implements IDdfPingable, IDdfFacetConst
{
  /*-
   class BDdfDevice
   {
     properties
     {
       communicator : BValue
         -- This driver uses the communicator from the network to communicate on behalf of this
         -- Device. The network must extend BDdfCommNetwork in order for this to work.
         -- The BValues for this property must implement BIDdfCommunicator
         -- This property is hidden because the default, null communicator acts as a pass-
         -- thru communicator and sends all communications to the communicator that is on
         -- the driver network.
         flags{hidden}
         default{[ new BDdfNullCommunicator() ]}
       deviceId : BDdfIdParams
         -- Descendants should override this property and define it with a default value
         -- That extends BDdfIdParams. This is the device's address on the field bus.
         default {[new BDdfIdParams()]}
       pingParameters : BDdfIdParams
         -- This should encapsulate any extra information necessary to ping the particular device.
         -- The default value needs to implement BIDdfPingParams so that the ddf
         -- Can automatically ping the device.
         default {[new BDdfIdParams()]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.BDdfDevice(2760755749)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>communicator</code> property.
   * This driver uses the communicator from the network
   * to communicate on behalf of this Device. The network
   * must extend BDdfCommNetwork in order for this to work.
   * The BValues for this property must implement BIDdfCommunicator
   * This property is hidden because the default, null communicator acts as a pass- thru communicator and sends all communications to the communicator that is on the driver network.
   * @see com.tridium.ddf.BDdfDevice#getCommunicator
   * @see com.tridium.ddf.BDdfDevice#setCommunicator
   */
  public static final Property communicator = newProperty(Flags.HIDDEN, new BDdfNullCommunicator(),null);

  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddf.BDdfDevice#communicator
   */
  public BValue getCommunicator() { return get(communicator); }

  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddf.BDdfDevice#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Property "deviceId"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>deviceId</code> property.
   * Descendants should override this property and define
   * it with a default value That extends BDdfIdParams.
   * This is the device's address on the field bus.
   * @see com.tridium.ddf.BDdfDevice#getDeviceId
   * @see com.tridium.ddf.BDdfDevice#setDeviceId
   */
  public static final Property deviceId = newProperty(0, new BDdfIdParams(),null);

  /**
   * Get the <code>deviceId</code> property.
   * @see com.tridium.ddf.BDdfDevice#deviceId
   */
  public BDdfIdParams getDeviceId() { return (BDdfIdParams)get(deviceId); }

  /**
   * Set the <code>deviceId</code> property.
   * @see com.tridium.ddf.BDdfDevice#deviceId
   */
  public void setDeviceId(BDdfIdParams v) { set(deviceId,v,null); }

////////////////////////////////////////////////////////////////
// Property "pingParameters"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>pingParameters</code> property.
   * This should encapsulate any extra information necessary
   * to ping the particular device. The default value needs
   * to implement BIDdfPingParams so that the ddf Can automatically
   * ping the device.
   * @see com.tridium.ddf.BDdfDevice#getPingParameters
   * @see com.tridium.ddf.BDdfDevice#setPingParameters
   */
  public static final Property pingParameters = newProperty(0, new BDdfIdParams(),null);

  /**
   * Get the <code>pingParameters</code> property.
   * @see com.tridium.ddf.BDdfDevice#pingParameters
   */
  public BDdfIdParams getPingParameters() { return (BDdfIdParams)get(pingParameters); }

  /**
   * Set the <code>pingParameters</code> property.
   * @see com.tridium.ddf.BDdfDevice#pingParameters
   */
  public void setPingParameters(BDdfIdParams v) { set(pingParameters,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDevice
////////////////////////////////////////////////////////////////
  public Type getNetworkType()
  {
    // TODO Auto-generated method stub
    return null;
  }

////////////////////////////////////////////////////////////////
// BDdfDevice
////////////////////////////////////////////////////////////////

  /**
   * Returns the value in the communicator slot casted as a BIDdfCommunicator.
   *
   *  Developers are encouraged to override the communicator property as an easier
   *  means of defining the ddf communicator than overridding this method.
   */
  public BIDdfCommunicator getDdfCommunicator()
  {
    return (BIDdfCommunicator)getCommunicator();
  }

  /**
   * Determines which type of request should best ping this device.
   *
   * The default behavior should be sufficient. It calls getDeviceId,
   * casts the result to BIDdfPingParams, and then returns whatever the
   * device id's getDdfPingRequestType method returns. If the
   * getDdfPingRequestType method returns null then this calls pingFail.
   */
  public Type getDdfPingRequestType()
  {
    BDdfIdParams deviceId = getDeviceId();
    if (deviceId instanceof BIDdfPingParams)
      return ((BIDdfPingParams)deviceId).getPingRequestType();
    else
    {
      if (getDdfCommunicator().getLog().isTraceOn())
        getDdfCommunicator().getLog().trace(
            DdfLexicon.ddfPingIdNeedsImplemented(deviceId.getType()));
      pingFail(DdfLexicon.ddfPingIdNeedsImplemented(deviceId.getType()));
      return null;
    }
  }

  /**
   * The 'doPing' method calls this method to instantiate an instance
   * of the driver's ping request for this device.
   *
   * This is accomplished as follows
   * 1.) Calls 'getDdfPingRequestType()'
   * 2.) Instantiates the resulting type to get a BIDdfPingRequest object.
   * 3.) Initializes the responseTimeout and remainingRetryCount on the
   *     BIDdfPingRequestObject
   * 4.) Sets the deviceId on the BIDdfPingRequest equal to a copy of the
   *     deviceId for this device.
   * 5.) Sets the pingParameters on the the BIDdfPingRequest equal to a
   *     copy of the pingParameters for this device.
   *
   * @return an instance of the driver's ping request for this device, as described.
   */
  public BIDdfPingRequest makePingRequest()
  {
    // Determines the type of ping message that the device id indicates can best ping the device
    Type ddfPingRequestType = getDdfPingRequestType();

    if (ddfPingRequestType!=null)
    {
      // Instantiates an empty instance of the appropriate type of ping request
      BIDdfPingRequest ddfPingRequest = (BIDdfPingRequest)ddfPingRequestType.getInstance();

      ddfPingRequest.setResponseTimeout(getDdfCommunicator().getDdfReceiver().getResponseTimeout());
      ddfPingRequest.setRemainingRetryCount(getDdfCommunicator().getDdfTransmitter().getMaxRetryCount());

      // Sets the deviceId
      ddfPingRequest.setDeviceId((BDdfIdParams)getDeviceId().newCopy());
      ddfPingRequest.setReadParameters((BDdfIdParams)getPingParameters().newCopy());

      // Returns the BIDdfPingRequest -- it's now ready to go to the ddfCommunicator
      return ddfPingRequest;
    }
    else
      return null;
  }

  /**
   * This is the default implementation of the 'ping' action. This is a one-size-fits-all
   * implementation of the 'ping' method that should suffice for most, if not all, drivers.
   *
   * This does the following:
   * 1.) Calls 'makePingRequest' to construct the appropriate instance of the driver's
   *     ping request.
   * 2.) Adds this device and all other devices under the same network with the equivalent
   *     deviceId to the pingableSource array of the ping request.
   * 3.) Calls 'communicateSync' and passes in the pingRequest. This blocks the ping thread
   *     until the response is received or timesout. The developer driver framework automatically
   *     calls pingOk() or pingFail() on this device if a response is received or times out.
   */
  public void doPing() throws Exception
  { // Gets an instance of a BIDdfPingRequst that can ping this device
    BIDdfPingRequest pingRequest = makePingRequest();
    if (pingRequest!=null)
    {
      // Gets the pingable source that is already in the ping message
      Array<IDdfPingable> pingableSource = new Array<>(IDdfPingable.class);
      // Adds this and any other device components that are for the same actual device as this device
      BDdfNetwork network = (BDdfNetwork)getNetwork(); // Gets the network
      BDevice[] dbDevices = network.getDevices();        // Gets all devices under the network
      for (int i=0; i<dbDevices.length; i++)             // Loops through all devices under the network
      {
        if (dbDevices[i] instanceof BDdfDevice)         // Sanity check
        {
          BDdfDevice ddfDevice = (BDdfDevice)dbDevices[i];
          if (ddfDevice==this ||                                 // If the device is this device OR
              ddfDevice.getDeviceId().equivalent(getDeviceId())) // If the device's id matches the same actual device as this device
          {
            if (!(pingableSource.contains(ddfDevice)))           // If the device is not already included among the pingable source
              pingableSource.add(ddfDevice);                     // Then this adds the device to the pingable source
          }
        }
      }
      // Updates the pingableSource for the ping request
      pingRequest.setPingableSource(pingableSource.trim());

      // Blocks to keep the health monitor from spinning and placing infinite ping requests on the communicator
      DdfRequestUtil.communicateSync(getDdfCommunicator(), pingRequest); // The ping request receives a callback with the response or the timeout. It automatically calls pingOk or pingFail.
    }
  }

}
