/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddf;

import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;

/**
 *
 * BDdfCommDevice is the ancestor for Niagara AX Ddf Devices that will
 * have their own real ddf communicator.
 *
 * @author    lperkins
 * @creation  Oct 16, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public abstract class BDdfCommDevice
  extends BDdfDevice
  implements BIDdfCommunicating
{
  /*-
  class BDdfCommDevice
  {
    properties
    {
      communicator : BValue
        -- This component communicates on behalf of this device
        -- The BValues for this property must implement BIDdfCommunicator
        default{[ new BDdfCommunicator() ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddf.BDdfCommDevice(4112839461)1.0$ @*/
/* Generated Thu Oct 25 11:30:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * This component communicates on behalf of this device
   * The BValues for this property must implement BIDdfCommunicator
   * @see com.tridium.ddf.BDdfCommDevice#getCommunicator
   * @see com.tridium.ddf.BDdfCommDevice#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddf.BDdfCommDevice#communicator
   */
  public BValue getCommunicator() { return get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddf.BDdfCommDevice#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfCommDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  public void started() throws Exception
  {
    wasCommEnabled=isCommEnabled();
    super.started();
  }
  
  /**
   * Monitors the 'status' property and stops driver i/o
   * if the 'status' is disabled or fault. Starts driver
   * i/o if the 'status' was disabled and/or fault but is
   * no longer disabled or fault.
   */
  public void changed(Property property, Context context)
  {
    if (isRunning())
    {
      if (property.equals(status))
      {
        boolean isCommEnabled = isCommEnabled();
        try
        {
          if (wasCommEnabled)
          {
            if (isCommEnabled)
            {
              // wasCommEnabled = true and also isCommEnabled = true,
              // communication is already enabled so let's do nothing
            }
            else
            {
              // wasCommEnabled = true but now isCommEnabled = false
              // let's stop communications
              disableComm();
            }
          }
          else 
          {
            if (isCommEnabled)
            {
              // wasStartable = false but now isStartable = true
              // let's start this and all descendants
              enableComm();
            }
            //else
            //{
                // wasStartable = false yet isStartable = false also
                // we cannot start this or any descenadants under this
                // scenario.
            //}
          }
        }
        finally
        {
          wasCommEnabled = isCommEnabled;
        }
      }
    }
    super.changed(property, context);
  }
  
////////////////////////////////////////////////////////////////
// BDdfCommDevice
////////////////////////////////////////////////////////////////
  
  /**
   * Determines whether the communicator and background processor
   * can be started.
   * 
   * @return true if neither fatalFault nor disabled
   */
  protected boolean isCommEnabled()
  {
    return ! (isFault() || isDisabled());
  }
  
  /**
   * This method is called from the 'changed' method if the status
   * changes away from fault and disabled. This calls the
   * 'startCommunicating' method of the communicator.
   */
  protected void enableComm()
  {
    getDdfCommunicator().startCommunicating();
  }
  
  /**
   * This method is called from the 'changed' method if the status
   * changes to fault or disabled. This calls the 'stopCommunicating'
   * method of the communicator.
   */
  protected void disableComm()
  {
    getDdfCommunicator().stopCommunicating();
  }
  
////////////////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////////////// 

  // The following variable helps the 'changed' method stop and possibly
  // restart driver communications if this object is disabled or goes to
  // fault
  boolean wasCommEnabled = false;
}
