/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.util;

import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBooleanOverride is the override argument for BooleanWritable.
 *
 * @author    Brian Frank
 * @creation  21 Jun 04
 * @version   $Revision: 1$ $Date: 6/22/04 8:35:23 AM EDT$
 * @since     Baja 1.0
 */
public class BBooleanOverride
  extends BOverride
{

  /*-

  class BBooleanOverride
  {
    properties
    {
      value: boolean
        -- Value of the override.
        default {[ false ]}
    }

  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.util.BBooleanOverride(2939614609)1.0$ @*/
/* Generated Mon Jun 21 20:34:27 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * Value of the override.
   * @see javax.baja.control.util.BBooleanOverride#getValue
   * @see javax.baja.control.util.BBooleanOverride#setValue
   */
  public static final Property value = newProperty(0, false,null);
  
  /**
   * Get the <code>value</code> property.
   * @see javax.baja.control.util.BBooleanOverride#value
   */
  public boolean getValue() { return getBoolean(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see javax.baja.control.util.BBooleanOverride#value
   */
  public void setValue(boolean v) { setBoolean(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanOverride.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBooleanOverride(BRelTime duration, boolean value)
  {                                          
    setDuration(duration);
    setValue(value);
  }

  public BBooleanOverride(boolean value)
  {                                   
    setValue(value);
  }

  public BBooleanOverride()
  {
  }

}
