/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BNumericPoint defines a read only numeric control point.
 *
 * @author    Dan Giorgis
 * @creation  15 Nov 00
 * @version   $Revision: 37$ $Date: 3/28/05 11:40:32 AM EST$
 * @since     Baja 1.0
 */
public class BNumericPoint
  extends BControlPoint
  implements BINumeric
{ 

  public static final Property facets = newProperty(0, BFacets.makeNumeric());
  
  /*-
  
  class BNumericPoint
  {
    properties
    {
      out: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.BNumericPoint(3687621534)1.0$ @*/
/* Generated Tue Mar 30 07:58:03 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see javax.baja.control.BNumericPoint#getOut
   * @see javax.baja.control.BNumericPoint#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see javax.baja.control.BNumericPoint#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see javax.baja.control.BNumericPoint#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericPoint.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  /**
   * Return the vaule as a double.
   */
  public final double getNumeric() { return getOut().getValue(); }

  /**
   * Return getFacets().
   */
  public final BFacets getNumericFacets() { return getFacets(); }

  /**
   * Get the control output value.
   */
  public final BStatusValue getOutStatusValue() { return getOut(); }

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////  

  /**
   * Default implementation is to do nothing.
   */
  public void onExecute(BStatusValue out, Context cx)
  {
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  /**
   * Get the icon.
   */
  public BIcon getIcon() 
  { 
    BValue dynamic = get("icon");
    if (dynamic instanceof BIcon)
      return (BIcon)dynamic;
    return icon; 
  }
  private static final BIcon icon = BIcon.std("control/numericPoint.png");

}
