/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import javax.baja.control.enums.BPriorityLevel;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BInterface;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BIWritablePoint interface is implement by Baja control points.
 *
 * @author    Andy Saunders
 * @creation  08 Sept 03
 * @version   $Revision: 6$ $Date: 10/4/06 2:35:09 PM EDT$
 * @since     Niagara 3.0
 */
public interface BIWritablePoint
  extends BInterface
{
  
  /**
   * Get the active priority level
   */
  public BPriorityLevel getActiveLevel();
  
  /**
   * Get current StatusValue for the specified input level. 
   *
   * @since Niagara 3.2
   */
  public BStatusValue getInStatusValue(BPriorityLevel level);

  /**
   * Get frozen property for the specified input level. 
   *
   * @since Niagara 3.2
   */
  public Property getInProperty(BPriorityLevel level);
  

  public static final Type TYPE = Sys.loadType(BIWritablePoint.class);
  
}
