
/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import java.util.logging.Level;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.control.util.BEnumOverride;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.util.ObjectUtil;

/**
 * BEnumWritable defines a writable control point with 16 input levels.
 *
 * @author    Dan Giorgis
 * @creation  17 Nov 00
 * @version   $Revision: 37$ $Date: 7/27/10 12:19:13 PM EDT$
 * @since     Baja 1.0
 */
public class BEnumWritable
  extends BEnumPoint
  implements BIWritablePoint
{

  /*-

  class BEnumWritable
  {
    properties
    {
      in1: BStatusEnum
        -- The last command at this priority level.
        -- Commands at emergency level 1 are persisted
        flags { readonly }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in2: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in3: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in4: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in5: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in6: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in7: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in8: BStatusEnum
        -- The last command at this priority level.
        -- Commands at manual level 8 are persisted
        flags { readonly }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in9: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in10: BStatusEnum
        -- The last command at this priority level.
        flags { summary, transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in11: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in12: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in13: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in14: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in15: BStatusEnum
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}
      in16: BStatusEnum
        -- The last command at this priority level.
        flags { summary, transient }
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}

      fallback: BStatusEnum
        -- This is the value to use if none of the levels are valid.
        default {[ new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus) ]}

      overrideExpiration: BAbsTime
        -- Time which override will expire
        flags { operator, readonly }
        default {[ BAbsTime.NULL ]}
    }

    actions
    {
      emergencyOverride(arg: BDynamicEnum)
        -- To set an output value at the Emergency level (1).
        default {[ BDynamicEnum.DEFAULT ]}
      emergencyAuto()
        -- To clear an output value set at the Emergency level (1).

      override(arg: BEnumOverride)
        -- To set an output value at the Manual level (8).
        flags { operator }
        default {[ new BEnumOverride() ]}
      auto()
        -- To clear an output value set at the Manual level (8).
        flags { operator }

      set(arg: BDynamicEnum)
        -- Set the fallback property value.
        flags { operator }
        default {[ BDynamicEnum.DEFAULT ]}
    }
  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.BEnumWritable(1876704310)1.0$ @*/
/* Generated Tue Jun 22 13:23:20 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "in1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in1</code> property.
   * The last command at this priority level. Commands at emergency level 1 are persisted
   * @see javax.baja.control.BEnumWritable#getIn1
   * @see javax.baja.control.BEnumWritable#setIn1
   */
  public static final Property in1 = newProperty(Flags.READONLY, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in1</code> property.
   * @see javax.baja.control.BEnumWritable#in1
   */
  public BStatusEnum getIn1() { return (BStatusEnum)get(in1); }
  
  /**
   * Set the <code>in1</code> property.
   * @see javax.baja.control.BEnumWritable#in1
   */
  public void setIn1(BStatusEnum v) { set(in1,v,null); }

////////////////////////////////////////////////////////////////
// Property "in2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in2</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn2
   * @see javax.baja.control.BEnumWritable#setIn2
   */
  public static final Property in2 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in2</code> property.
   * @see javax.baja.control.BEnumWritable#in2
   */
  public BStatusEnum getIn2() { return (BStatusEnum)get(in2); }
  
  /**
   * Set the <code>in2</code> property.
   * @see javax.baja.control.BEnumWritable#in2
   */
  public void setIn2(BStatusEnum v) { set(in2,v,null); }

////////////////////////////////////////////////////////////////
// Property "in3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in3</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn3
   * @see javax.baja.control.BEnumWritable#setIn3
   */
  public static final Property in3 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in3</code> property.
   * @see javax.baja.control.BEnumWritable#in3
   */
  public BStatusEnum getIn3() { return (BStatusEnum)get(in3); }
  
  /**
   * Set the <code>in3</code> property.
   * @see javax.baja.control.BEnumWritable#in3
   */
  public void setIn3(BStatusEnum v) { set(in3,v,null); }

////////////////////////////////////////////////////////////////
// Property "in4"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in4</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn4
   * @see javax.baja.control.BEnumWritable#setIn4
   */
  public static final Property in4 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in4</code> property.
   * @see javax.baja.control.BEnumWritable#in4
   */
  public BStatusEnum getIn4() { return (BStatusEnum)get(in4); }
  
  /**
   * Set the <code>in4</code> property.
   * @see javax.baja.control.BEnumWritable#in4
   */
  public void setIn4(BStatusEnum v) { set(in4,v,null); }

////////////////////////////////////////////////////////////////
// Property "in5"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in5</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn5
   * @see javax.baja.control.BEnumWritable#setIn5
   */
  public static final Property in5 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in5</code> property.
   * @see javax.baja.control.BEnumWritable#in5
   */
  public BStatusEnum getIn5() { return (BStatusEnum)get(in5); }
  
  /**
   * Set the <code>in5</code> property.
   * @see javax.baja.control.BEnumWritable#in5
   */
  public void setIn5(BStatusEnum v) { set(in5,v,null); }

////////////////////////////////////////////////////////////////
// Property "in6"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in6</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn6
   * @see javax.baja.control.BEnumWritable#setIn6
   */
  public static final Property in6 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in6</code> property.
   * @see javax.baja.control.BEnumWritable#in6
   */
  public BStatusEnum getIn6() { return (BStatusEnum)get(in6); }
  
  /**
   * Set the <code>in6</code> property.
   * @see javax.baja.control.BEnumWritable#in6
   */
  public void setIn6(BStatusEnum v) { set(in6,v,null); }

////////////////////////////////////////////////////////////////
// Property "in7"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in7</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn7
   * @see javax.baja.control.BEnumWritable#setIn7
   */
  public static final Property in7 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in7</code> property.
   * @see javax.baja.control.BEnumWritable#in7
   */
  public BStatusEnum getIn7() { return (BStatusEnum)get(in7); }
  
  /**
   * Set the <code>in7</code> property.
   * @see javax.baja.control.BEnumWritable#in7
   */
  public void setIn7(BStatusEnum v) { set(in7,v,null); }

////////////////////////////////////////////////////////////////
// Property "in8"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in8</code> property.
   * The last command at this priority level. Commands at manual level 8 are persisted
   * @see javax.baja.control.BEnumWritable#getIn8
   * @see javax.baja.control.BEnumWritable#setIn8
   */
  public static final Property in8 = newProperty(Flags.READONLY, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in8</code> property.
   * @see javax.baja.control.BEnumWritable#in8
   */
  public BStatusEnum getIn8() { return (BStatusEnum)get(in8); }
  
  /**
   * Set the <code>in8</code> property.
   * @see javax.baja.control.BEnumWritable#in8
   */
  public void setIn8(BStatusEnum v) { set(in8,v,null); }

////////////////////////////////////////////////////////////////
// Property "in9"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in9</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn9
   * @see javax.baja.control.BEnumWritable#setIn9
   */
  public static final Property in9 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in9</code> property.
   * @see javax.baja.control.BEnumWritable#in9
   */
  public BStatusEnum getIn9() { return (BStatusEnum)get(in9); }
  
  /**
   * Set the <code>in9</code> property.
   * @see javax.baja.control.BEnumWritable#in9
   */
  public void setIn9(BStatusEnum v) { set(in9,v,null); }

////////////////////////////////////////////////////////////////
// Property "in10"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in10</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn10
   * @see javax.baja.control.BEnumWritable#setIn10
   */
  public static final Property in10 = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in10</code> property.
   * @see javax.baja.control.BEnumWritable#in10
   */
  public BStatusEnum getIn10() { return (BStatusEnum)get(in10); }
  
  /**
   * Set the <code>in10</code> property.
   * @see javax.baja.control.BEnumWritable#in10
   */
  public void setIn10(BStatusEnum v) { set(in10,v,null); }

////////////////////////////////////////////////////////////////
// Property "in11"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in11</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn11
   * @see javax.baja.control.BEnumWritable#setIn11
   */
  public static final Property in11 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in11</code> property.
   * @see javax.baja.control.BEnumWritable#in11
   */
  public BStatusEnum getIn11() { return (BStatusEnum)get(in11); }
  
  /**
   * Set the <code>in11</code> property.
   * @see javax.baja.control.BEnumWritable#in11
   */
  public void setIn11(BStatusEnum v) { set(in11,v,null); }

////////////////////////////////////////////////////////////////
// Property "in12"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in12</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn12
   * @see javax.baja.control.BEnumWritable#setIn12
   */
  public static final Property in12 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in12</code> property.
   * @see javax.baja.control.BEnumWritable#in12
   */
  public BStatusEnum getIn12() { return (BStatusEnum)get(in12); }
  
  /**
   * Set the <code>in12</code> property.
   * @see javax.baja.control.BEnumWritable#in12
   */
  public void setIn12(BStatusEnum v) { set(in12,v,null); }

////////////////////////////////////////////////////////////////
// Property "in13"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in13</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn13
   * @see javax.baja.control.BEnumWritable#setIn13
   */
  public static final Property in13 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in13</code> property.
   * @see javax.baja.control.BEnumWritable#in13
   */
  public BStatusEnum getIn13() { return (BStatusEnum)get(in13); }
  
  /**
   * Set the <code>in13</code> property.
   * @see javax.baja.control.BEnumWritable#in13
   */
  public void setIn13(BStatusEnum v) { set(in13,v,null); }

////////////////////////////////////////////////////////////////
// Property "in14"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in14</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn14
   * @see javax.baja.control.BEnumWritable#setIn14
   */
  public static final Property in14 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in14</code> property.
   * @see javax.baja.control.BEnumWritable#in14
   */
  public BStatusEnum getIn14() { return (BStatusEnum)get(in14); }
  
  /**
   * Set the <code>in14</code> property.
   * @see javax.baja.control.BEnumWritable#in14
   */
  public void setIn14(BStatusEnum v) { set(in14,v,null); }

////////////////////////////////////////////////////////////////
// Property "in15"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in15</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn15
   * @see javax.baja.control.BEnumWritable#setIn15
   */
  public static final Property in15 = newProperty(Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in15</code> property.
   * @see javax.baja.control.BEnumWritable#in15
   */
  public BStatusEnum getIn15() { return (BStatusEnum)get(in15); }
  
  /**
   * Set the <code>in15</code> property.
   * @see javax.baja.control.BEnumWritable#in15
   */
  public void setIn15(BStatusEnum v) { set(in15,v,null); }

////////////////////////////////////////////////////////////////
// Property "in16"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in16</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BEnumWritable#getIn16
   * @see javax.baja.control.BEnumWritable#setIn16
   */
  public static final Property in16 = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in16</code> property.
   * @see javax.baja.control.BEnumWritable#in16
   */
  public BStatusEnum getIn16() { return (BStatusEnum)get(in16); }
  
  /**
   * Set the <code>in16</code> property.
   * @see javax.baja.control.BEnumWritable#in16
   */
  public void setIn16(BStatusEnum v) { set(in16,v,null); }

////////////////////////////////////////////////////////////////
// Property "fallback"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fallback</code> property.
   * This is the value to use if none of the levels are
   * valid.
   * @see javax.baja.control.BEnumWritable#getFallback
   * @see javax.baja.control.BEnumWritable#setFallback
   */
  public static final Property fallback = newProperty(0, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus),null);
  
  /**
   * Get the <code>fallback</code> property.
   * @see javax.baja.control.BEnumWritable#fallback
   */
  public BStatusEnum getFallback() { return (BStatusEnum)get(fallback); }
  
  /**
   * Set the <code>fallback</code> property.
   * @see javax.baja.control.BEnumWritable#fallback
   */
  public void setFallback(BStatusEnum v) { set(fallback,v,null); }

////////////////////////////////////////////////////////////////
// Property "overrideExpiration"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>overrideExpiration</code> property.
   * Time which override will expire
   * @see javax.baja.control.BEnumWritable#getOverrideExpiration
   * @see javax.baja.control.BEnumWritable#setOverrideExpiration
   */
  public static final Property overrideExpiration = newProperty(Flags.OPERATOR|Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>overrideExpiration</code> property.
   * @see javax.baja.control.BEnumWritable#overrideExpiration
   */
  public BAbsTime getOverrideExpiration() { return (BAbsTime)get(overrideExpiration); }
  
  /**
   * Set the <code>overrideExpiration</code> property.
   * @see javax.baja.control.BEnumWritable#overrideExpiration
   */
  public void setOverrideExpiration(BAbsTime v) { set(overrideExpiration,v,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyOverride"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyOverride</code> action.
   * To set an output value at the Emergency level (1).
   * @see javax.baja.control.BEnumWritable#emergencyOverride()
   */
  public static final Action emergencyOverride = newAction(0,BDynamicEnum.DEFAULT,null);
  
  /**
   * Invoke the <code>emergencyOverride</code> action.
   * @see javax.baja.control.BEnumWritable#emergencyOverride
   */
  public void emergencyOverride(BDynamicEnum arg) { invoke(emergencyOverride,arg,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyAuto"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyAuto</code> action.
   * To clear an output value set at the Emergency level
   * (1).
   * @see javax.baja.control.BEnumWritable#emergencyAuto()
   */
  public static final Action emergencyAuto = newAction(0,null);
  
  /**
   * Invoke the <code>emergencyAuto</code> action.
   * @see javax.baja.control.BEnumWritable#emergencyAuto
   */
  public void emergencyAuto() { invoke(emergencyAuto,null,null); }

////////////////////////////////////////////////////////////////
// Action "override"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>override</code> action.
   * To set an output value at the Manual level (8).
   * @see javax.baja.control.BEnumWritable#override()
   */
  public static final Action override = newAction(Flags.OPERATOR,new BEnumOverride(),null);
  
  /**
   * Invoke the <code>override</code> action.
   * @see javax.baja.control.BEnumWritable#override
   */
  public void override(BEnumOverride arg) { invoke(override,arg,null); }

////////////////////////////////////////////////////////////////
// Action "auto"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>auto</code> action.
   * To clear an output value set at the Manual level (8).
   * @see javax.baja.control.BEnumWritable#auto()
   */
  public static final Action auto = newAction(Flags.OPERATOR,null);
  
  /**
   * Invoke the <code>auto</code> action.
   * @see javax.baja.control.BEnumWritable#auto
   */
  public void auto() { invoke(auto,null,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * Set the fallback property value.
   * @see javax.baja.control.BEnumWritable#set()
   */
  public static final Action set = newAction(Flags.OPERATOR,BDynamicEnum.DEFAULT,null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see javax.baja.control.BEnumWritable#set
   */
  public void set(BDynamicEnum arg) { invoke(set,arg,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnumWritable.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////

  public void started()
  throws Exception
  {
    super.started();
    support.started();
  }

  public final boolean isWritablePoint()
  {
    return true;
  }

  public BValue getActionParameterDefault(Action action)
  {
    if (action == set) return getFallback().getValueValue();
    if (action == override)
    {
      BEnumOverride o = new BEnumOverride(support.getMaxOverrideDuration(),getOut().getValue());
      o.setMaxOverrideDuration(support.getMaxOverrideDuration());
      return o;
    }
    if (action == emergencyOverride) return getOut().getValueValue();
    return super.getActionParameterDefault(action);
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if (support.isInput(slot) ||
        slot == fallback ||
        slot == override ||
        slot == emergencyOverride ||
        slot == set)
      return getFacets();

    return super.getSlotFacets(slot);
  }

  public void onExecute(BStatusValue o, Context cx)
  {
    support.onExecute(o, cx);
    
    // Need to check to see if the point facets enum range changed,
    // and if so, update the working value as well as any applicable inputs     
    BDynamicEnum val = (BDynamicEnum)o.getValueValue();
    BEnumRange range = val.getRange();
    
    BFacets facets = getFacets();
    BEnumRange facetsRange = (BEnumRange)(facets.get(BFacets.RANGE));
    if (facetsRange == null)
      facetsRange = BEnumRange.NULL;
    if (facetsRange.equals(range))
      return; // range check is fine, nothing to do
    
    // enum range has changed, so update the working variable first
    // so the output will be reflected
    val = BDynamicEnum.make(val.getOrdinal(), facetsRange);
    o.setValueValue(val);
    
    // Next update any applicable inputs, but use a special context
    // so that they don't trigger another execute.
    Property[] props = getFrozenPropertiesArray();
    for (int i = 0; i < props.length; i++)
    {
      if (support.isInput(props[i]) ||
          (props[i] == fallback))
      {
        try
        {
          BStatusEnum input = (BStatusEnum)get(props[i]);
          val = input.getValue();
          if (facetsRange.equals(val.getRange()))
            continue; // range check is fine, skip to next input
        
          val = BDynamicEnum.make(val.getOrdinal(), facetsRange);
          input.set(BStatusEnum.value, val, noExecuteContext);
        }
        catch(Exception e) 
        {
          if (log.isLoggable(Level.FINE))
            log.log(Level.FINE, "Unable to update range facet of enum input on "+toPathString()+"/"+props[i].getName(), e);
        }
      }      
    }    
  }

  WritableSupport writableSupport()
  {
    return support;
  }

////////////////////////////////////////////////////////////////
// IWritablePoint
////////////////////////////////////////////////////////////////

  public final BPriorityLevel getActiveLevel()
  {
    return support.getActiveLevel();
  }

  public final BStatusValue getInStatusValue(BPriorityLevel level)
  {
    return support.getLevel(level.getOrdinal());
  }

  public final Property getInProperty(BPriorityLevel level)
  {
    return support.getLevel(level.getOrdinal()).getPropertyInParent();
  }

  public final BStatusEnum getLevel(BPriorityLevel level)
  {
    return (BStatusEnum)support.getLevel(level.getOrdinal());
  }

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  public void doEmergencyOverride(BDynamicEnum v)
  {
    support.emergencyOverride(v);
  }

  public void doEmergencyAuto()
  {
    support.emergencyAuto();
  }

  public void doOverride(BEnumOverride v)
  {
    support.override(v);
  }

  public void doAuto()
  {
    support.auto();
  }

  public void doSet(BDynamicEnum v)
  {
    support.set(v);
  }

  /**
   * Callback when the given Action is invoked with the given argument and Context. Overridden
   * here to check if the given Context has a non-null user (indicating server-side handling of
   * a user-invoked Action) and the action is a {@link #set}, {@link #override}, or
   * {@link #emergencyOverride}. If so, then a range check is optionally performed against the
   * action argument if any MIN/MAX facets are specified for the value of this point.
   *
   * @since Niagara 4.10u8
   */
  @Override
  void fwCheckActionInvocation(Action action, BValue arg, Context context)
  {
    if (!ObjectUtil.SERVER_MIN_MAX_CHECK_DISABLED && context != null && context.getUser() != null &&
        (action.equals(set) || action.equals(override) || action.equals(emergencyOverride)))
    {
      ObjectUtil.checkMinMaxFacetsOnValue(
        arg instanceof BEnumOverride ? arg.asComplex().get(BEnumOverride.value) : arg,
        getSlotFacets(action), context
      );
    }
  }

////////////////////////////////////////////////////////////////
// WritableSupport
////////////////////////////////////////////////////////////////

  final class EnumWritableSupport extends WritableSupport
  {
    EnumWritableSupport(BEnumWritable pt) { super(pt); }

    Property in1()  { return in1; }
    Property in2()  { return in2; }
    Property in3()  { return in3; }
    Property in4()  { return in4; }
    Property in5()  { return in5; }
    Property in6()  { return in6; }
    Property in7()  { return in7; }
    Property in8()  { return in8; }
    Property in9()  { return in9; }
    Property in10() { return in10; }
    Property in11() { return in11; }
    Property in12() { return in12; }
    Property in13() { return in13; }
    Property in14() { return in14; }
    Property in15() { return in15; }
    Property in16() { return in16; }

    BStatusValue getFallback()
    {
      return BEnumWritable.this.getFallback();
    }

    void setOverrideExpiration(BAbsTime time)
    {
      BEnumWritable.this.setOverrideExpiration(time);
    }

    BAbsTime getOverrideExpiration()
    {
      return BEnumWritable.this.getOverrideExpiration();
    }

    void setValue(BStatusValue from, BStatusValue to)
    {
      ((BStatusEnum)to).setValue( ((BStatusEnum)from).getValue() );
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  WritableSupport support = new EnumWritableSupport(this);
}
