/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BEnumPoint defines a read only enum control point.
 *
 * @author    Dan Giorgis
 * @creation  02 May 01
 * @version   $Revision: 22$ $Date: 3/28/05 11:40:32 AM EST$
 * @since     Baja 1.0
 */
public class BEnumPoint
  extends BDiscretePoint
  implements BIEnum
{

  public static final Property facets = newProperty(0, BFacets.makeEnum());
  
  /*-

  class BEnumPoint
  {
    properties
    {
      out: BStatusEnum
        -- The out slot of a BBooleanPoint is a
        -- BStatusEnum
        flags { operator, readonly, transient, summary }
        default {[ new BStatusEnum() ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.BEnumPoint(3677224148)1.0$ @*/
/* Generated Tue Mar 30 13:40:18 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * The out slot of a BBooleanPoint is a BStatusEnum
   * @see javax.baja.control.BEnumPoint#getOut
   * @see javax.baja.control.BEnumPoint#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see javax.baja.control.BEnumPoint#out
   */
  public BStatusEnum getOut() { return (BStatusEnum)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see javax.baja.control.BEnumPoint#out
   */
  public void setOut(BStatusEnum v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnumPoint.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getValue(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }

  /**
   * Get the control output value.
   */
  public final BStatusValue getOutStatusValue() { return getOut(); }

  /**
   * Return the result of <code>out.value.isActive</code>.
   */
  public final boolean isActive() { return getEnum().isActive(); }

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////  

  /**
   * Default implementation is to do nothing.
   */
  public void onExecute(BStatusValue out, Context cx)
  {
    // Need to check to see if the point facets enum range changed,
    // and if so, update the working value
    BDynamicEnum val = (BDynamicEnum)out.getValueValue();
    BEnumRange range = val.getRange();
    
    BFacets facets = getFacets();
    BEnumRange facetsRange = (BEnumRange)(facets.get(BFacets.RANGE));
    if (facetsRange == null)
      facetsRange = BEnumRange.NULL;
    if (facetsRange.equals(range))
      return; // range check is fine, nothing to do
    
    // enum range has changed, so update the working variable
    // so the output will be reflected
    val = BDynamicEnum.make(val.getOrdinal(), facetsRange);
    out.setValueValue(val);
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  /**
   * Get the icon.
   */
  public BIcon getIcon() 
  { 
    BValue dynamic = get("icon");
    if (dynamic instanceof BIcon)
      return (BIcon)dynamic;
    return icon; 
  }
  private static final BIcon icon = BIcon.std("control/enumPoint.png");

}
